/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.storage.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.storage.client.StorageEvent;
import com.google.gwt.storage.client.StorageImpl;

@PartialSupport
public final class Storage {
    static final StorageImpl impl = (StorageImpl)GWT.create(StorageImpl.class);
    private static Storage localStorage;
    private static Storage sessionStorage;
    private static StorageSupportDetector supportDetectorImpl;
    private final String storage;

    public static HandlerRegistration addStorageEventHandler(StorageEvent.Handler handler) {
        return impl.addStorageEventHandler(handler);
    }

    public static Storage getLocalStorageIfSupported() {
        if (Storage.isLocalStorageSupported()) {
            if (localStorage == null) {
                localStorage = new Storage("localStorage");
            }
            return localStorage;
        }
        return null;
    }

    public static Storage getSessionStorageIfSupported() {
        if (Storage.isSessionStorageSupported()) {
            if (sessionStorage == null) {
                sessionStorage = new Storage("sessionStorage");
            }
            return sessionStorage;
        }
        return null;
    }

    public static boolean isLocalStorageSupported() {
        return Storage.getStorageSupportDetector().isLocalStorageSupported();
    }

    public static boolean isSessionStorageSupported() {
        return Storage.getStorageSupportDetector().isSessionStorageSupported();
    }

    public static boolean isSupported() {
        return Storage.isLocalStorageSupported() && Storage.isSessionStorageSupported();
    }

    public static void removeStorageEventHandler(StorageEvent.Handler handler) {
        impl.removeStorageEventHandler(handler);
    }

    private static StorageSupportDetector getStorageSupportDetector() {
        if (supportDetectorImpl == null) {
            supportDetectorImpl = (StorageSupportDetector)GWT.create(StorageSupportDetector.class);
        }
        return supportDetectorImpl;
    }

    private Storage(String storage) {
        this.storage = storage;
    }

    public void clear() {
        impl.clear(this.storage);
    }

    public String getItem(String key) {
        return impl.getItem(this.storage, key);
    }

    public int getLength() {
        return impl.getLength(this.storage);
    }

    public String key(int index) {
        return impl.key(this.storage, index);
    }

    public void removeItem(String key) {
        impl.removeItem(this.storage, key);
    }

    public void setItem(String key, String data) {
        assert (key.length() > 0);
        impl.setItem(this.storage, key, data);
    }

    private static class StorageSupportDetectorNo
    extends StorageSupportDetector {
        private StorageSupportDetectorNo() {
        }

        public boolean isLocalStorageSupported() {
            return false;
        }

        public boolean isSessionStorageSupported() {
            return false;
        }
    }

    private static class StorageSupportDetector {
        private final boolean isLocalStorageSupported = this.detectLocalStorageSupport();
        private final boolean isSessionStorageSupported = this.detectSessionStorageSupport();

        private StorageSupportDetector() {
        }

        public boolean isLocalStorageSupported() {
            return this.isLocalStorageSupported;
        }

        public boolean isSessionStorageSupported() {
            return this.isSessionStorageSupported;
        }

        private native boolean detectLocalStorageSupport();

        private native boolean detectSessionStorageSupport();
    }
}

