/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.storage.client;

import com.google.gwt.storage.client.Storage;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageMap
extends AbstractMap<String, String> {
    private Storage storage;
    private StorageEntrySet entrySet;

    public StorageMap(Storage storage) {
        assert (storage != null) : "storage cannot be null";
        this.storage = storage;
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.storage.getItem(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            if (!value.equals(this.storage.getItem(this.storage.key(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new StorageEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return null;
        }
        return this.storage.getItem(key.toString());
    }

    @Override
    public String put(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key and value cannot be null!");
        }
        String old = this.storage.getItem(key);
        this.storage.setItem(key, value);
        return old;
    }

    @Override
    public String remove(Object key) {
        String k = key.toString();
        String old = this.storage.getItem(k);
        this.storage.removeItem(k);
        return old;
    }

    @Override
    public int size() {
        return this.storage.getLength();
    }

    private boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StorageEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private StorageEntrySet() {
        }

        @Override
        public void clear() {
            StorageMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && StorageMap.this.containsKey(key) && StorageMap.this.eq(StorageMap.this.get(key), e.getValue());
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new StorageEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null) {
                return false;
            }
            String key = e.getKey().toString();
            String value = StorageMap.this.storage.getItem(key);
            if (StorageMap.this.eq(value, e.getValue())) {
                return StorageMap.this.remove(key) != null;
            }
            return false;
        }

        @Override
        public int size() {
            return StorageMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StorageEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private int index = -1;
        private boolean removed = false;

        private StorageEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < StorageMap.this.size() - 1;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this.hasNext()) {
                ++this.index;
                this.removed = false;
                return new StorageEntry(StorageMap.this.storage.key(this.index));
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index >= 0 && this.index < StorageMap.this.size()) {
                if (this.removed) {
                    throw new IllegalStateException("Cannot remove() Entry - already removed!");
                }
                StorageMap.this.storage.removeItem(StorageMap.this.storage.key(this.index));
                this.removed = true;
                --this.index;
            } else {
                throw new IllegalStateException("Cannot remove() Entry - index=" + this.index + ", size=" + StorageMap.this.size());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StorageEntry
    implements Map.Entry<String, String> {
        private final String key;

        public StorageEntry(String key) {
            this.key = key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return StorageMap.this.eq(this.key, e.getKey()) && StorageMap.this.eq(this.getValue(), e.getValue());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return StorageMap.this.storage.getItem(this.key);
        }

        @Override
        public int hashCode() {
            String value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public String setValue(String value) {
            String oldValue = StorageMap.this.storage.getItem(this.key);
            StorageMap.this.storage.setItem(this.key, value);
            return oldValue;
        }
    }
}

