/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.newspaces;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.gadget.services.newspaces.IntranetSpace;
import org.exoplatform.platform.gadget.services.newspaces.IntranetSpaceService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.utils.TimeConvertUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntranetSpaceServiceImpl
implements IntranetSpaceService {
    private static final Log LOG = ExoLogger.getLogger(IntranetSpaceServiceImpl.class);
    private RepositoryService _repoService;
    private final String SOCIAL_WORKSPACE = "social";
    private final String SPACE_HOME = "production/soc:spaces";
    private static final String JCR_ROOT = "/jcr:root";

    public IntranetSpaceServiceImpl(RepositoryService repoService) throws Exception {
        this._repoService = repoService;
    }

    private Node getSpaceHome() throws Exception {
        if (this._repoService != null) {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Session session = this.getSession(sProvider);
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode("production/soc:spaces")) {
                    return rootNode.getNode("production/soc:spaces");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Can not get get SpaceHome", (Throwable)e);
                sProvider.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IntranetSpace> getLatestCreatedSpace(int maxday, String language, List<String> allGroupAndMembershipOfUser) {
        if (allGroupAndMembershipOfUser == null || allGroupAndMembershipOfUser.size() == 0) {
            return new ArrayList<IntranetSpace>();
        }
        if (maxday <= 0) {
            maxday = 10;
        }
        String userName = allGroupAndMembershipOfUser != null && allGroupAndMembershipOfUser.size() > 0 ? allGroupAndMembershipOfUser.get(0) : null;
        ArrayList<IntranetSpace> listSpaces = new ArrayList<IntranetSpace>();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node spaceHomeNode = this.getSpaceHome();
            if (spaceHomeNode == null) {
                ArrayList<IntranetSpace> arrayList = listSpaces;
                return arrayList;
            }
            Calendar pastTime = Calendar.getInstance();
            pastTime.setTime(new Date(new Date().getTime() - (long)(maxday * 24 * 60 * 60 * 1000)));
            QueryManager qm = spaceHomeNode.getSession().getWorkspace().getQueryManager();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(JCR_ROOT).append(spaceHomeNode.getPath()).append("//element(*,soc:spacedefinition)");
            stringBuffer.append("[@exo:dateCreated >= xs:dateTime('" + ISO8601.format((Calendar)pastTime) + "')]");
            stringBuffer.append(" order by @exo:dateCreated descending");
            String pathQuery = stringBuffer.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                IntranetSpace space = new IntranetSpace();
                space.setDisplayName(spaceNode.getProperty("soc:displayName").getString());
                space.setDescription(spaceNode.getProperty("soc:description").getString());
                space.setUrl(spaceNode.getProperty("soc:url").getString());
                Date createdDate = spaceNode.getProperty("exo:dateCreated").getDate().getTime();
                space.setCreatedDate(createdDate);
                Locale local = new Locale(language);
                String createdTimeAgo = TimeConvertUtils.convertXTimeAgo((Date)IntranetSpaceServiceImpl.getGreenwichMeanTime(createdDate).getTime(), (String)"yyyy/MM/dd", (Locale)local, (int)TimeConvertUtils.MONTH);
                space.setCreatedTimeAgo(createdTimeAgo);
                space.setRegistration(spaceNode.getProperty("soc:registration").getString());
                space.setVisibility(spaceNode.getProperty("soc:visibility").getString());
                String groupId = spaceNode.getProperty("soc:groupId").getString();
                if (allGroupAndMembershipOfUser.contains(groupId)) {
                    space.setIsMember(true);
                }
                if (spaceNode.hasProperty("soc:invitedMembersId")) {
                    String[] invitedUsers;
                    for (String user : invitedUsers = this.convertValuesToStrings(spaceNode.getProperty("soc:invitedMembersId").getValues())) {
                        if (!user.equals(userName)) continue;
                        space.setIsInvitedUser(true);
                        break;
                    }
                }
                if (spaceNode.hasProperty("soc:pendingMembersId")) {
                    String[] pendingUsers;
                    for (String user : pendingUsers = this.convertValuesToStrings(spaceNode.getProperty("soc:pendingMembersId").getValues())) {
                        if (!user.equals(userName)) continue;
                        space.setIsPendingUser(true);
                        break;
                    }
                }
                String avartarUrl = null;
                PortalContainer portalContainer = PortalContainer.getInstance();
                IdentityManager iManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
                Identity spaceIdentity = iManager.getOrCreateIdentity("space", spaceNode.getProperty("soc:name").getString(), true);
                Profile profile = spaceIdentity.getProfile();
                avartarUrl = profile.getAvatarUrl();
                space.setAvatarURL(avartarUrl);
                listSpaces.add(space);
            }
            ArrayList<IntranetSpace> arrayList = listSpaces;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get Latest Created Space", (Throwable)e);
            List<IntranetSpace> list = null;
            return list;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<IntranetSpace> requestToJoinOpenSpace(String spaceUrl, String userId) {
        if (userId == null) {
            return new ArrayList<IntranetSpace>();
        }
        try {
            Space result;
            PortalContainer portalContainer = PortalContainer.getInstance();
            SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceByUrl(spaceUrl);
            if (space != null) {
                if (spaceService.isInvitedUser(space, userId)) {
                    spaceService.addMember(space, userId);
                } else if (!spaceService.isMember(space, userId)) {
                    spaceService.addPendingUser(space, userId);
                }
            }
            if (spaceService.isMember(result = spaceService.getSpaceByUrl(spaceUrl), userId)) {
                IntranetSpace intranetSpaceBean = new IntranetSpace();
                intranetSpaceBean.setUrl(result.getUrl());
                intranetSpaceBean.setDisplayName(result.getDisplayName());
                intranetSpaceBean.setIsMember(true);
                ArrayList<IntranetSpace> listIntranetSpace = new ArrayList<IntranetSpace>();
                listIntranetSpace.add(intranetSpaceBean);
                return listIntranetSpace;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can not join space " + spaceUrl), (Throwable)e);
        }
        return new ArrayList<IntranetSpace>();
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this._repoService.getCurrentRepository();
        return sessionProvider.getSession("social", currentRepo);
    }

    private String[] convertValuesToStrings(Value[] values) throws Exception {
        if (values.length == 1) {
            return new String[]{values[0].getString()};
        }
        String[] strArrays = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strArrays[i] = values[i].getString();
        }
        return strArrays;
    }

    public static Calendar getGreenwichMeanTime(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(date.getTime() - (long)gmtoffset);
        return calendar;
    }
}

