/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.trial;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.Utils;
import org.exoplatform.trial.TrialFilter;
import org.picocontainer.Startable;

public class TrialService
implements Startable {
    private static final String PRODUCT_NAME = "Platform";
    public static Calendar remindDate;
    private ScheduledExecutorService executor;

    public TrialService(ProductInformations productInformations, InitParams params) throws MissingProductInformationException {
        Utils.productNameAndVersion = "Platform " + productInformations.getVersion();
        Utils.registrationFormUrl = ((ValueParam)params.get((Object)"registrationFormUrl")).getValue();
        Utils.pingBackUrl = ((ValueParam)params.get((Object)"pingBackUrl")).getValue();
        Utils.KEY_CONTENT = ((ValueParam)params.get((Object)"KeyContent")).getValue().trim();
        String tmpValue = ((ValueParam)params.get((Object)"delayPeriod")).getValue();
        Utils.delayPeriod = tmpValue == null ? 30 : Integer.parseInt(tmpValue);
    }

    public void start() {
        String keyContent;
        FileInputStream propertiesInputStream;
        Properties properties = new Properties();
        if (new File(Utils.HOME_CONFIG_FILE_LOCATION).exists()) {
            FileInputStream inputStream;
            try {
                inputStream = new FileInputStream(Utils.HOME_CONFIG_FILE_LOCATION);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException(Utils.HOME_CONFIG_FILE_LOCATION + " file couldn't be found.", exception);
            }
            try {
                properties.loadFromXML(inputStream);
            }
            catch (InvalidPropertiesFormatException exception) {
                throw new RuntimeException("File format error: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
            }
            catch (IOException exception) {
                throw new RuntimeException("Error while reading file: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException exception) {
                throw new RuntimeException("Error while closing stream after reading file: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
            }
        }
        if (!new File(Utils.EXO_HOME_FOLDER).exists()) {
            new File(Utils.EXO_HOME_FOLDER).mkdirs();
        }
        properties.put("UnlockKey", "");
        properties.put("remindDate", "");
        properties.put("formDisplayed", "false");
        try {
            FileOutputStream outputStream = new FileOutputStream(Utils.HOME_CONFIG_FILE_LOCATION);
            properties.storeToXML(outputStream, Utils.HOME_CONFIG_FILE_LOCATION);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException("Error while creating file: " + Utils.HOME_CONFIG_FILE_LOCATION + ". The file may be locked.", exception);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while storing entries in file: " + Utils.HOME_CONFIG_FILE_LOCATION + ". The file may be locked.", exception);
        }
        return;
        try {
            propertiesInputStream = new FileInputStream(Utils.HOME_CONFIG_FILE_LOCATION);
            properties.loadFromXML(propertiesInputStream);
        }
        catch (FileNotFoundException exception) {
            throw new RuntimeException("Error while creating file: " + Utils.HOME_CONFIG_FILE_LOCATION + ". The file may be locked.", exception);
        }
        catch (InvalidPropertiesFormatException exception) {
            throw new RuntimeException("File format error: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading file: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
        }
        try {
            ((InputStream)propertiesInputStream).close();
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while closing stream after reading file: " + Utils.HOME_CONFIG_FILE_LOCATION, exception);
        }
        String hashMD5Added = "";
        if (!properties.containsKey("UnlockKey")) {
            if (!properties.containsKey(Utils.productNameAndVersion)) {
                Enumeration<Object> keys = properties.keys();
                if (keys.hasMoreElements()) {
                    hashMD5Added = properties.getProperty((String)keys.nextElement());
                }
            } else {
                hashMD5Added = properties.getProperty(Utils.productNameAndVersion);
            }
        } else {
            hashMD5Added = properties.getProperty("UnlockKey");
        }
        try {
            keyContent = Utils.getModifiedMD5Code((byte[])Utils.KEY_CONTENT.getBytes());
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException("Error while encoding the key.", exception);
        }
        boolean bl = TrialFilter.unlocked = hashMD5Added != null && !hashMD5Added.equals("") && hashMD5Added.equals(keyContent);
        if (!TrialFilter.unlocked) {
            String loopfuseFormDisplayedString = properties.getProperty("formDisplayed");
            Utils.loopfuseFormDisplayed = loopfuseFormDisplayedString != null && loopfuseFormDisplayedString.equals("") ? Boolean.parseBoolean(loopfuseFormDisplayedString) : false;
            String remindDateString = properties.getProperty("remindDate");
            if (remindDateString == null || remindDateString.equals("")) {
                return;
            }
            try {
                remindDate = Utils.parseDateBase64((String)remindDateString);
                this.computeUnlockedInformation();
            }
            catch (ParseException exception) {
                throw new RuntimeException("Error while decoding the file content.", exception);
            }
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    TrialService.this.computeUnlockedInformation();
                }
            }, 1L, 1L, TimeUnit.DAYS);
        }
    }

    private void computeUnlockedInformation() {
        Calendar today = Calendar.getInstance();
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (remindDate.compareTo(today) < 0 || Utils.delayPeriod <= 0) {
            Utils.outdated = true;
            TrialFilter.unlocked = false;
        } else {
            TrialFilter.unlocked = true;
            Utils.daysBeforeExpire = (int)TimeUnit.MILLISECONDS.toDays(remindDate.getTimeInMillis() - today.getTimeInMillis());
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

