/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.trial;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.trial.Utils;
import org.exoplatform.web.filter.Filter;
import org.picocontainer.Startable;

public class TrialService
implements Startable {
    private static String registrationFormUrl = null;
    private static String extendFormUrl = null;
    private static String pingBackUrl = null;
    private static String calledUrl = null;
    private static String productNameAndVersion = null;
    private static String productCode = null;
    private static String KEY_CONTENT = null;
    private static boolean loopfuseFormDisplayed = false;
    private static boolean outdated = false;
    private static boolean dismissed = false;
    private static boolean firstStart = false;
    private static int delayPeriod = 30;
    private static int nbDaysBeforeExpiration = 0;
    private static Calendar remindDate;
    private ScheduledExecutorService executor;

    public TrialService(ProductInformations productInformations, InitParams params) throws MissingProductInformationException {
        productNameAndVersion = "Platform" + productInformations.getVersion().trim();
        registrationFormUrl = ((ValueParam)params.get((Object)"registrationFormUrl")).getValue();
        extendFormUrl = ((ValueParam)params.get((Object)"extendFormUrl")).getValue();
        pingBackUrl = ((ValueParam)params.get((Object)"pingBackUrl")).getValue();
        KEY_CONTENT = ((ValueParam)params.get((Object)"KeyContent")).getValue().trim();
        String tmpValue = ((ValueParam)params.get((Object)"delayPeriod")).getValue();
        delayPeriod = tmpValue == null || tmpValue.isEmpty() ? 30 : Integer.parseInt(tmpValue);
        Utils.HOME_CONFIG_FILE_LOCATION = Utils.EXO_HOME_FOLDER + "/" + productNameAndVersion;
    }

    public void start() {
        String remindDateString;
        String productNameAndVersionHashed = Utils.getModifiedMD5Code(productNameAndVersion.getBytes());
        if (!new File(Utils.HOME_CONFIG_FILE_LOCATION).exists()) {
            firstStart = true;
            productCode = TrialService.generateProductCode();
            Utils.writeToFile("Platform", productNameAndVersionHashed, Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("remindDate", "", Utils.HOME_CONFIG_FILE_LOCATION);
            Utils.writeToFile("formDisplayed", "false", Utils.HOME_CONFIG_FILE_LOCATION);
            return;
        }
        String productNameAndVersionReadFromFile = Utils.readFromFile("Platform", Utils.HOME_CONFIG_FILE_LOCATION);
        if (!productNameAndVersionHashed.equals(productNameAndVersionReadFromFile)) {
            throw new IllegalStateException("Inconsistent product informations.");
        }
        productCode = Utils.readFromFile("ProductCode", Utils.HOME_CONFIG_FILE_LOCATION);
        String loopfuseFormDisplayedString = Utils.readFromFile("formDisplayed", Utils.HOME_CONFIG_FILE_LOCATION);
        if (loopfuseFormDisplayedString != null && !loopfuseFormDisplayedString.isEmpty()) {
            loopfuseFormDisplayed = Boolean.parseBoolean(loopfuseFormDisplayedString);
        }
        if ((remindDateString = Utils.readFromFile("remindDate", Utils.HOME_CONFIG_FILE_LOCATION)) == null || remindDateString.isEmpty()) {
            firstStart = true;
            return;
        }
        remindDate = Utils.parseDateBase64(remindDateString);
        TrialService.computeUnlockedInformation();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                dismissed = false;
                TrialService.computeUnlockedInformation();
            }
        }, 1L, 1L, TimeUnit.DAYS);
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public static String computeRemindDateFromTodayBase64() {
        if (delayPeriod <= 0 || outdated) {
            return "";
        }
        Calendar remindDate = Calendar.getInstance();
        remindDate.add(5, delayPeriod);
        return Utils.formatDateBase64(remindDate);
    }

    public static boolean isFirstStart() {
        return firstStart;
    }

    public static String getRegistrationFormUrl() {
        return registrationFormUrl;
    }

    public static String getProductNameAndVersion() {
        return productNameAndVersion;
    }

    public static int getDelayPeriod() {
        return delayPeriod;
    }

    public static int getNbDaysBeforeExpiration() {
        return nbDaysBeforeExpiration;
    }

    public static boolean isLoopfuseFormDisplayed() {
        return loopfuseFormDisplayed;
    }

    public static boolean isOutdated() {
        return outdated;
    }

    public static String getPingBackUrl() {
        return pingBackUrl;
    }

    public static Calendar getRemindDate() {
        return remindDate;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public static String getCalledUrl() {
        return calledUrl;
    }

    public static String getExtendFormUrl() {
        return extendFormUrl;
    }

    public static String getProductCode() {
        return productCode;
    }

    private static String generateProductCode() {
        String productCode = productNameAndVersion + Math.random() + KEY_CONTENT;
        return Utils.getModifiedMD5Code(productCode.getBytes());
    }

    public static boolean isDismissed() {
        return dismissed;
    }

    private static void computeUnlockedInformation() {
        Calendar today = Calendar.getInstance();
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        if (remindDate.compareTo(today) <= 0 || delayPeriod <= 0) {
            remindDate = today;
            delayPeriod = 0;
            outdated = true;
        } else {
            outdated = false;
            nbDaysBeforeExpiration = (int)TimeUnit.MILLISECONDS.toDays(remindDate.getTimeInMillis() - today.getTimeInMillis());
        }
    }

    private static int decodeEvaluationKey(String productCode, String evaluationKey) {
        StringBuffer evaluationKeyBuffer = new StringBuffer(new String(Base64.decodeBase64((byte[])evaluationKey.getBytes())));
        int length = Integer.parseInt(evaluationKeyBuffer.substring(4, 6));
        evaluationKeyBuffer.replace(4, 6, "");
        String productCodeHashed = evaluationKeyBuffer.substring(0, length);
        if (!productCodeHashed.equals(Utils.getModifiedMD5Code(productCode.getBytes()))) {
            return 0;
        }
        String periodString = evaluationKeyBuffer.substring(length);
        periodString = new String(Base64.decodeBase64((byte[])periodString.getBytes()));
        int period = Integer.parseInt(periodString) / 3;
        return period;
    }

    public static class PingBackServlet
    extends HttpServlet {
        private static final long serialVersionUID = 6467955354840693802L;

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (PingBackServlet.isConnectedToInternet()) {
                loopfuseFormDisplayed = true;
                Utils.writePingBackFormDisplayed(Utils.HOME_CONFIG_FILE_LOCATION, loopfuseFormDisplayed);
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doPost(request, response);
        }

        public static boolean isConnectedToInternet() {
            String pingServerURL = pingBackUrl.substring(0, pingBackUrl.indexOf("/", "http://url".length()));
            try {
                URL url = new URL(pingServerURL);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.connect();
                return 404 != urlConn.getResponseCode();
            }
            catch (MalformedURLException e) {
                System.err.println("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL);
            }
            catch (IOException e) {
                System.err.println("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL);
            }
            return false;
        }
    }

    public static class UnlockServlet
    extends HttpServlet {
        private static final long serialVersionUID = -4806814673109318163L;

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String dismiss = request.getParameter("dismiss");
            if (dismiss != null && dismiss.equals("true")) {
                if (!outdated && remindDate != null) {
                    dismissed = true;
                }
                response.sendRedirect(calledUrl);
                return;
            }
            String rdate = request.getParameter("rdate");
            if (rdate == null || rdate.isEmpty()) {
                String hashMD5Added = request.getParameter("hashMD5");
                if (hashMD5Added == null) {
                    response.sendRedirect(calledUrl);
                    return;
                }
                try {
                    delayPeriod = TrialService.decodeEvaluationKey(productCode, hashMD5Added);
                }
                catch (Exception exception) {
                    delayPeriod = 0;
                }
                if (delayPeriod <= 0) {
                    outdated = true;
                    request.setAttribute("errorMessage", (Object)"Sorry this evaluation key is not valid.");
                    request.getRequestDispatcher("/jsp/extend.jsp").include((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                productCode = TrialService.generateProductCode();
                Utils.writeToFile("ProductCode", productCode, Utils.HOME_CONFIG_FILE_LOCATION);
                outdated = false;
                rdate = TrialService.computeRemindDateFromTodayBase64();
            }
            try {
                remindDate = Utils.parseDateBase64(rdate);
                TrialService.computeUnlockedInformation();
                if (!outdated) {
                    firstStart = false;
                    dismissed = true;
                    Utils.writeRemindDate(rdate, Utils.HOME_CONFIG_FILE_LOCATION);
                }
                response.sendRedirect(calledUrl);
            }
            catch (Exception exception) {
                delayPeriod = 0;
                outdated = true;
                response.sendRedirect(calledUrl);
                return;
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doPost(request, response);
        }
    }

    public static class TrialFilter
    implements Filter {
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            boolean isIgnoringRequest = this.isIgnoredRequest(httpServletRequest.getSession(true).getServletContext(), httpServletRequest.getRequestURI());
            if (!outdated && dismissed || isIgnoringRequest) {
                chain.doFilter(request, response);
                return;
            }
            if (calledUrl == null) {
                calledUrl = httpServletRequest.getRequestURI();
            }
            httpServletResponse.sendRedirect("/trial/jsp/registration.jsp");
        }

        private boolean isIgnoredRequest(ServletContext context, String url) {
            String fileName = url.substring(url.indexOf("/"));
            String mimeType = context.getMimeType(fileName);
            return mimeType != null;
        }
    }
}

