/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeNodeTypesTemplatesService
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger(UpgradeNodeTypesTemplatesService.class);
    private TemplateService templateService = null;
    private ConfigurationManager configurationManager = null;
    private RepositoryService repositoryService = null;
    private DMSConfiguration dmsConfiguration = null;
    private String cmsTemplatesBasePath = null;
    private List<String> pluginNamesList = new ArrayList<String>();
    private String oldVersion;

    public UpgradeNodeTypesTemplatesService(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, TemplateService templateService, ConfigurationManager configurationManager, InitParams initParams) {
        super(initParams);
        this.templateService = templateService;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        this.dmsConfiguration = dmsConfiguration;
        ArrayList pluginNamesList = initParams.getValuesParam("plugin-names").getValues();
        for (Object object : pluginNamesList) {
            this.pluginNamesList.add((String)object);
        }
        this.cmsTemplatesBasePath = nodeHierarchyCreator.getJcrPath("templatesPath");
        if (this.cmsTemplatesBasePath == null) {
            throw new RuntimeException("UpgradeNodeTypesTemplatesService: templatesPath path couldn't be found");
        }
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            Component component;
            this.oldVersion = oldVersion;
            ExternalComponentPlugins externalComponentPlugins = this.configurationManager.getConfiguration().getExternalComponentPlugins(TemplateService.class.getName());
            ArrayList componentPlugins = new ArrayList();
            if (externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
                log.info((Object)"add Template Services externalComponentPlugins");
                componentPlugins.addAll(externalComponentPlugins.getComponentPlugins());
            }
            if ((component = this.configurationManager.getComponent(TemplateService.class)).getComponentPlugins() != null) {
                log.info((Object)"add Template Services componentPlugins");
                componentPlugins.addAll(component.getComponentPlugins());
            }
            for (ComponentPlugin componentPlugin : componentPlugins) {
                log.info((Object)("Begin processing Component Plugin '" + componentPlugin.getName() + "'..."));
                if (!componentPlugin.getType().equals(TemplatePlugin.class.getName()) || !this.pluginNamesList.contains(componentPlugin.getName())) {
                    log.info((Object)"not upgradable component plugin");
                    continue;
                }
                InitParams initParams = componentPlugin.getInitParams();
                ValueParam locationParam = initParams.getValueParam("storedLocation");
                String storedLocation = locationParam.getValue();
                ValueParam param = initParams.getValueParam("autoCreateInNewRepository");
                boolean autoCreateInNewRepository = false;
                if (param != null) {
                    autoCreateInNewRepository = Boolean.parseBoolean(param.getValue());
                }
                ArrayList<TemplateConfig> templatesConfig = new ArrayList<TemplateConfig>();
                Iterator iter = initParams.getObjectParamIterator();
                while (iter.hasNext()) {
                    Object object = ((ObjectParameter)iter.next()).getObject();
                    if (!(object instanceof TemplateConfig)) continue;
                    templatesConfig.add((TemplateConfig)object);
                }
                if (autoCreateInNewRepository) {
                    log.info((Object)"templates are defined in multiple repositories, upgrade in all repos");
                    List repositories = this.repositoryService.getConfig().getRepositoryConfigurations();
                    for (RepositoryEntry repo : repositories) {
                        log.info((Object)("upgrade templates in '" + repo.getName() + "' repository"));
                        this.upgradePredefinedTemplates(repo.getName(), templatesConfig, storedLocation);
                    }
                    continue;
                }
                ValueParam valueParam = initParams.getValueParam("repository");
                String repository = valueParam != null ? valueParam.getValue() : this.repositoryService.getCurrentRepository().getConfiguration().getName();
                log.info((Object)("upgrade templates in '" + repository + "' repository"));
                this.upgradePredefinedTemplates(repository, templatesConfig, storedLocation);
            }
        }
        catch (Exception exception) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            log.error((Object)sw.toString());
        }
    }

    private void upgradePredefinedTemplates(String repositoryName, List<TemplateConfig> templatesConfig, String storedLocation) throws Exception {
        ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration.getConfig();
        String workspace = dmsRepoConfig.getSystemWorkspace();
        Session session = repository.getSystemSession(workspace);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath);
        for (TemplateConfig templateConfig : templatesConfig) {
            List nodetypes = templateConfig.getNodeTypes();
            Iterator i$ = nodetypes.iterator();
            while (i$.hasNext()) {
                List skins;
                TemplateConfig.NodeType object;
                TemplateConfig.NodeType nodeType = object = (TemplateConfig.NodeType)i$.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("upgrade dialogs for nodeType '" + nodeType.getNodetypeName() + "'"));
                }
                List dialogs = nodeType.getReferencedDialog();
                this.updateTemplateContent(storedLocation, nodeType, dialogs, TemplatePlugin.DIALOGS, templatesHome);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("upgrade views for nodeType '" + nodeType.getNodetypeName() + "'"));
                }
                List views = nodeType.getReferencedView();
                this.updateTemplateContent(storedLocation, nodeType, views, TemplatePlugin.VIEWS, templatesHome);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("upgrade skins for nodeType '" + nodeType.getNodetypeName() + "'"));
                }
                if ((skins = nodeType.getReferencedSkin()) == null) continue;
                this.updateTemplateContent(storedLocation, nodeType, skins, TemplatePlugin.SKINS, templatesHome);
            }
        }
        session.logout();
    }

    private void updateTemplateContent(String basePath, TemplateConfig.NodeType nodeType, List templates, String templateType, Node templatesHome) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            InputStream in = this.configurationManager.getInputStream(basePath + templateFileName);
            String templateNodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.lastIndexOf("."));
            if (!templatesHome.hasNode(nodeType.getNodetypeName())) continue;
            Node nodeTypeHome = templatesHome.getNode(nodeType.getNodetypeName());
            Node specifiedTemplatesHome = nodeTypeHome.getNode(templateType);
            if (specifiedTemplatesHome.hasNode(templateNodeName)) {
                Node templateNode = specifiedTemplatesHome.getNode(templateNodeName);
                super.addNodeVersion(templateNode, this.oldVersion);
                this.templateService.addTemplate(templateType, nodeType.getNodetypeName(), nodeType.getLabel(), nodeType.getDocumentTemplate(), templateNodeName, template.getParsedRoles(), in, templatesHome);
                continue;
            }
            throw new IllegalStateException("Template for :" + templateNodeName + "not found");
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

