/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.websphere;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.web.security.Credentials;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.security.TransientTokenService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class InitiateLoginServlet
extends AbstractHttpServlet {
    private static final Logger log = LoggerFactory.getLogger(InitiateLoginServlet.class);
    public static final String COOKIE_NAME = "rememberme";
    public static final String CREDENTIALS = "credentials";
    public static final String WASReqURL_COOKIE = "WASReqURL";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html; charset=UTF-8");
        HttpSession session = req.getSession();
        Credentials credentials = (Credentials)session.getAttribute(CREDENTIALS);
        if (credentials == null) {
            PortalContainer pContainer = PortalContainer.getInstance();
            ServletContext context = pContainer.getPortalContext();
            String token = InitiateLoginServlet.getRememberMeTokenCookie(req);
            if (token != null) {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                credentials = tokenService.validateToken(token, false);
                if (credentials == null) {
                    log.debug((Object)("Login initiated with no credentials in session but found token an invalid " + token + " " + "that will be cleared in next response"));
                    Cookie cookie = new Cookie(COOKIE_NAME, "");
                    cookie.setPath(req.getContextPath());
                    cookie.setMaxAge(0);
                    resp.addCookie(cookie);
                    this.showLoginForm(req, resp);
                } else {
                    log.debug((Object)("Login initiated with no credentials in session but found token " + token + " with existing credentials, " + "performing authentication"));
                    this.sendAuth(req, resp, credentials.getUsername(), token);
                }
            } else {
                log.debug((Object)"Login initiated with no credentials in session and no token cookie, redirecting to login page");
                this.showLoginForm(req, resp);
            }
        } else {
            TransientTokenService tokenService = (TransientTokenService)AbstractTokenService.getInstance(TransientTokenService.class);
            String token = tokenService.createToken(credentials);
            req.getSession().removeAttribute(CREDENTIALS);
            log.debug((Object)"Login initiated with credentials in session, performing authentication");
            this.sendAuth(req, resp, credentials.getUsername(), token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoginForm(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String initialURI = this.getInitialURI(req);
        try {
            String queryString = (String)req.getAttribute("javax.servlet.forward.query_string");
            if ((String)req.getAttribute("javax.servlet.forward.query_string") != null) {
                initialURI = initialURI + "?" + queryString;
            }
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
            this.getServletContext().getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            req.removeAttribute("org.gatein.portal.login.initial_uri");
        }
    }

    private String getInitialURI(HttpServletRequest req) {
        String initialURI = "";
        Cookie[] cookies = req.getCookies();
        for (int index = 0; index <= cookies.length; ++index) {
            String cookieName = cookies[index].getName();
            if (!WASReqURL_COOKIE.equals(cookieName)) continue;
            initialURI = cookies[index].getValue();
            break;
        }
        return initialURI;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void sendAuth(HttpServletRequest req, HttpServletResponse resp, String jUsername, String jPassword) throws IOException {
        String initialURI = this.getInitialURI(req);
        if (!initialURI.endsWith("/")) {
            initialURI = initialURI + "/";
        }
        String url = initialURI + "j_security_check?j_username=" + jUsername + "&j_password=" + jPassword;
        url = resp.encodeRedirectURL(url);
        resp.sendRedirect(url);
    }

    public static String getRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }
}

