/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginHistoryListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log log = ExoLogger.getLogger(LoginHistoryListener.class);
    private ExoContainerContext context;

    public LoginHistoryListener(ExoContainerContext context) throws Exception {
        this.context = context;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
        try {
            ExoContainer container = ExoContainerContext.getContainerByName((String)this.context.getPortalContainerName());
            LoginHistoryService loginHistoryService = (LoginHistoryService)container.getComponentInstanceOfType(LoginHistoryService.class);
            long now = System.currentTimeMillis();
            if (now - loginHistoryService.getLastLogin(userId) > 180000L) {
                loginHistoryService.addLoginHistoryEntry(userId, now);
                log.info((Object)("User " + userId + " logged in."));
            }
        }
        catch (Exception e) {
            log.debug((Object)("Error while logging the login of user '" + userId + "': " + e.getMessage()), (Throwable)e);
        }
    }
}

