/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.statistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jcr.Node;
import org.apache.commons.lang.ArrayUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.ext.ntdef.NTFolder;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.platform.common.space.statistic.SpaceAccess;
import org.exoplatform.platform.common.space.statistic.SpaceAccessService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LastSpaceAccessServiceImpl
implements SpaceAccessService {
    private static final Log LOG = ExoLogger.getLogger(LastSpaceAccessServiceImpl.class);
    private ChromatticLifeCycle lifeCycle;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private Executor executor;
    private static final String PARENT_PLATFORM_RELATIVE_PATH = "Platform";
    private static final String SEPARATOR = "@";
    private static final String PARENT_TOOLBAR_RELATIVE_PATH = "toolbar";
    private static final String PARENT_RELATIVE_PATH = "Platform/toolbar";
    private static final String CHROMATTIC_LIFECYCLE_NAME = "spaceaccess";
    private static final String SPACE_ACCESS_NODE_NAME = "spaces-access-log";
    private static final String SPACE_ACCESS_LIFECYCLE_ROOT_PATH = "/Users/";

    public LastSpaceAccessServiceImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
        this.executor = Executors.newCachedThreadPool();
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @Override
    public void updateSpaceAccess(final String spaceId, final String userId) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                int i;
                Object[] spaces;
                if (LastSpaceAccessServiceImpl.this.lifeCycle.getContext() == null) {
                    LastSpaceAccessServiceImpl.this.lifeCycle.openContext();
                }
                String parentNodePath = null;
                try {
                    parentNodePath = LastSpaceAccessServiceImpl.this.getUserApplicationDataNodePath(userId, true);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                SpaceAccess spaceAccess = (SpaceAccess)LastSpaceAccessServiceImpl.this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + LastSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME, false);
                if (spaceAccess == null) {
                    NTFolder parentNode = (NTFolder)LastSpaceAccessServiceImpl.this.getSession().findByPath(NTFolder.class, parentNodePath, false);
                    if (parentNode == null) {
                        throw new IllegalStateException("User ApplicationData node couldn't be found.");
                    }
                    spaceAccess = (SpaceAccess)LastSpaceAccessServiceImpl.this.getSession().create(SpaceAccess.class, LastSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME);
                    LastSpaceAccessServiceImpl.this.getSession().persist((Object)parentNode, (Object)spaceAccess);
                    LastSpaceAccessServiceImpl.this.getSession().save();
                    spaceAccess = (SpaceAccess)LastSpaceAccessServiceImpl.this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + LastSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME, false);
                }
                if ((spaces = spaceAccess.getSpaceAccessList()) == null || spaces.length == 0) {
                    spaces = (String[])ArrayUtils.add(null, (Object)(spaceId + LastSpaceAccessServiceImpl.SEPARATOR + "1"));
                    spaceAccess.setSpaceAccessList((String[])spaces);
                    LastSpaceAccessServiceImpl.this.getSession().save();
                    return;
                }
                String prefix = spaceId + LastSpaceAccessServiceImpl.SEPARATOR;
                String spaceAccessEntry = null;
                for (i = 0; i < spaces.length; ++i) {
                    String spaceAccessEntryTmp = spaces[i];
                    if (!spaceAccessEntryTmp.startsWith(prefix)) continue;
                    spaceAccessEntry = spaceAccessEntryTmp;
                    break;
                }
                int k = i;
                if (spaceAccessEntry != null && i != spaces.length - 1) {
                    spaces = (String[])ArrayUtils.remove((Object[])spaces, (int)i);
                    spaces = (String[])ArrayUtils.add((Object[])spaces, (Object)spaceAccessEntry);
                } else if (spaceAccessEntry == null) {
                    spaces = (String[])ArrayUtils.add((Object[])spaces, (Object)(spaceId + LastSpaceAccessServiceImpl.SEPARATOR + "1"));
                }
                spaceAccess.setSpaceAccessList((String[])spaces);
                LastSpaceAccessServiceImpl.this.getSession().save();
            }
        });
    }

    @Override
    public List<String> getSpaceAccessList(String userId) {
        String parentNodePath = this.getUserApplicationDataNodePath(userId, false);
        if (parentNodePath == null) {
            return new ArrayList<String>();
        }
        SpaceAccess spaceAccess = null;
        try {
            spaceAccess = (SpaceAccess)this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + SPACE_ACCESS_NODE_NAME, false);
        }
        catch (Exception exception) {
            LOG.error((Object)"spaceAccess for this user isn't yet created ", (Throwable)exception);
        }
        if (spaceAccess == null || spaceAccess.getSpaceAccessList() == null || spaceAccess.getSpaceAccessList().length == 0) {
            return new ArrayList<String>();
        }
        String[] spaces = spaceAccess.getSpaceAccessList();
        List<String> spacesList = Arrays.asList(spaces);
        for (int i = 0; i < spacesList.size(); ++i) {
            String space = spacesList.get(i);
            space = space.split(SEPARATOR)[0];
            spacesList.set(i, space);
        }
        return spacesList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getUserApplicationDataNodePath(String userId, boolean create) {
        String parentNodePath = null;
        try {
            Node userApplicationNode = this.nodeHierarchyCreator.getUserApplicationNode(SessionProvider.createSystemProvider(), userId);
            if (!userApplicationNode.hasNode(PARENT_RELATIVE_PATH)) {
                if (!create) return null;
                if (!userApplicationNode.hasNode(PARENT_PLATFORM_RELATIVE_PATH)) {
                    userApplicationNode.addNode(PARENT_PLATFORM_RELATIVE_PATH, "nt:folder");
                }
                userApplicationNode = userApplicationNode.addNode(PARENT_RELATIVE_PATH, "nt:folder");
                userApplicationNode.addMixin("mix:referenceable");
                userApplicationNode.getSession().save();
                parentNodePath = userApplicationNode.getPath();
                return parentNodePath.split(SPACE_ACCESS_LIFECYCLE_ROOT_PATH, 2)[1];
            } else {
                parentNodePath = userApplicationNode.getPath() + "/" + PARENT_RELATIVE_PATH;
            }
            return parentNodePath.split(SPACE_ACCESS_LIFECYCLE_ROOT_PATH, 2)[1];
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }
}

