/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.statistic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jcr.Node;
import org.apache.commons.lang.ArrayUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.ext.ntdef.NTFolder;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.platform.common.space.statistic.SpaceAccess;
import org.exoplatform.platform.common.space.statistic.SpaceAccessService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MostSpaceAccessServiceImpl
implements SpaceAccessService {
    private static final Log LOG = ExoLogger.getLogger(SpaceAccessService.class);
    private static final String PARENT_PLATFORM_RELATIVE_PATH = "Platform";
    private static final String PARENT_TOOLBAR_RELATIVE_PATH = "toolbar";
    private static final String PARENT_RELATIVE_PATH = "Platform/toolbar";
    private static final String SEPARATOR = "@";
    private static final String CHROMATTIC_LIFECYCLE_NAME = "spaceaccess";
    private static final String SPACE_ACCESS_NODE_NAME = "spaces-access-log";
    private static final String SPACE_ACCESS_LIFECYCLE_ROOT_PATH = "/Users/";
    private static final Comparator<String> spaceAccessComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            o1 = o1.split(MostSpaceAccessServiceImpl.SEPARATOR)[1];
            o2 = o2.split(MostSpaceAccessServiceImpl.SEPARATOR)[1];
            return o1.compareTo(o2);
        }
    };
    private ChromatticLifeCycle lifeCycle;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private Executor executor;

    public MostSpaceAccessServiceImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
        this.executor = Executors.newCachedThreadPool();
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @Override
    public void updateSpaceAccess(final String spaceId, final String userId) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Object[] spaces;
                if (MostSpaceAccessServiceImpl.this.lifeCycle.getContext() == null) {
                    MostSpaceAccessServiceImpl.this.lifeCycle.openContext();
                }
                String parentNodePath = null;
                try {
                    parentNodePath = MostSpaceAccessServiceImpl.this.getUserApplicationDataNodePath(userId, true);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                SpaceAccess spaceAccess = (SpaceAccess)MostSpaceAccessServiceImpl.this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + MostSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME, false);
                if (spaceAccess == null) {
                    NTFolder parentNode = (NTFolder)MostSpaceAccessServiceImpl.this.getSession().findByPath(NTFolder.class, parentNodePath, false);
                    if (parentNode == null) {
                        throw new IllegalStateException("User ApplicationData node couldn't be found.");
                    }
                    spaceAccess = (SpaceAccess)MostSpaceAccessServiceImpl.this.getSession().create(SpaceAccess.class, MostSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME);
                    MostSpaceAccessServiceImpl.this.getSession().persist((Object)parentNode, (Object)spaceAccess);
                    MostSpaceAccessServiceImpl.this.getSession().save();
                    spaceAccess = (SpaceAccess)MostSpaceAccessServiceImpl.this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + MostSpaceAccessServiceImpl.SPACE_ACCESS_NODE_NAME, false);
                }
                if ((spaces = spaceAccess.getSpaceAccessList()) == null || spaces.length == 0) {
                    spaces = (String[])ArrayUtils.add(null, (Object)(spaceId + MostSpaceAccessServiceImpl.SEPARATOR + "1"));
                    spaceAccess.setSpaceAccessList((String[])spaces);
                    MostSpaceAccessServiceImpl.this.getSession().save();
                    return;
                }
                String prefix = spaceId + MostSpaceAccessServiceImpl.SEPARATOR;
                String spaceAccessEntry = null;
                for (int i = 0; i < spaces.length; ++i) {
                    String spaceAccessEntryTmp = spaces[i];
                    if (!spaceAccessEntryTmp.startsWith(prefix)) continue;
                    spaceAccessEntry = spaceAccessEntryTmp;
                    break;
                }
                if (spaceAccessEntry != null) {
                    String[] spaceKeys = spaceAccessEntry.split(MostSpaceAccessServiceImpl.SEPARATOR);
                    int spaceAccessCount = Integer.parseInt(spaceKeys[1]);
                    spaceAccessEntry = spaceKeys[0] + MostSpaceAccessServiceImpl.SEPARATOR + ++spaceAccessCount;
                    spaces[i] = spaceAccessEntry;
                } else {
                    spaces = (String[])ArrayUtils.add((Object[])spaces, (Object)(spaceId + MostSpaceAccessServiceImpl.SEPARATOR + "1"));
                }
                Arrays.sort(spaces, spaceAccessComparator);
                spaceAccess.setSpaceAccessList((String[])spaces);
                MostSpaceAccessServiceImpl.this.getSession().save();
            }
        });
    }

    @Override
    public List<String> getSpaceAccessList(String userId) {
        String parentNodePath = this.getUserApplicationDataNodePath(userId, false);
        if (parentNodePath == null) {
            return new ArrayList<String>();
        }
        SpaceAccess spaceAccess = null;
        try {
            spaceAccess = (SpaceAccess)this.getSession().findByPath(SpaceAccess.class, parentNodePath + "/" + SPACE_ACCESS_NODE_NAME, false);
        }
        catch (Exception exception) {
            LOG.error((Object)"spaceAccess for this user isn't yet created ", (Throwable)exception);
        }
        if (spaceAccess == null || spaceAccess.getSpaceAccessList() == null || spaceAccess.getSpaceAccessList().length == 0) {
            return new ArrayList<String>();
        }
        String[] spaces = spaceAccess.getSpaceAccessList();
        List<String> spacesList = Arrays.asList(spaces);
        for (int i = 0; i < spacesList.size(); ++i) {
            String space = spacesList.get(i);
            space = space.split(SEPARATOR)[0];
            spacesList.set(i, space);
        }
        return spacesList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getUserApplicationDataNodePath(String userId, boolean create) {
        String parentNodePath = null;
        try {
            Node userApplicationNode = this.nodeHierarchyCreator.getUserApplicationNode(SessionProvider.createSystemProvider(), userId);
            if (!userApplicationNode.hasNode(PARENT_RELATIVE_PATH)) {
                if (!create) return null;
                if (!userApplicationNode.hasNode(PARENT_PLATFORM_RELATIVE_PATH)) {
                    userApplicationNode.addNode(PARENT_PLATFORM_RELATIVE_PATH, "nt:folder");
                }
                userApplicationNode = userApplicationNode.addNode(PARENT_RELATIVE_PATH, "nt:folder");
                userApplicationNode.addMixin("mix:referenceable");
                userApplicationNode.getSession().save();
                parentNodePath = userApplicationNode.getPath();
                return parentNodePath.split(SPACE_ACCESS_LIFECYCLE_ROOT_PATH, 2)[1];
            } else {
                parentNodePath = userApplicationNode.getPath() + "/" + PARENT_RELATIVE_PATH;
            }
            return parentNodePath.split(SPACE_ACCESS_LIFECYCLE_ROOT_PATH, 2)[1];
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }
}

