/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class AccountSetup
extends HttpServlet {
    private static final long serialVersionUID = 6467955354840693802L;
    public static final String ACCOUNT_SETUP_NODE = "accountSetup";
    private static Log logger = ExoLogger.getLogger(AccountSetup.class);
    private static final String USER_NAME_ACCOUNT = "username";
    private static final String FIRST_NAME_ACCOUNT = "firstNameAccount";
    private static final String LAST_NAME_ACCOUNT = "lastNameAccount";
    private static final String EMAIL_ACCOUNT = "emailAccount";
    private static final String USER_PASSWORD_ACCOUNT = "password";
    private static final String ADMIN_FIRST_NAME = "root";
    private static final String ADMIN_PASSWORD = "adminPassword";
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String PLATFORM_DEVELOPERS_GROUP = "/developers";
    private static final String PLATFORM_PLATFORM_USERS_GROUP = "/platform/users";
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private static final String INTRANET_HOME = "/portal/intranet";
    private static final String INITIAL_URI_PARAM = "initialURI";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String initialURI = request.getParameter(INITIAL_URI_PARAM);
        String userNameAccount = request.getParameter(USER_NAME_ACCOUNT);
        String firstNameAccount = request.getParameter(FIRST_NAME_ACCOUNT);
        String lastNameAccount = request.getParameter(LAST_NAME_ACCOUNT);
        String emailAccount = request.getParameter(EMAIL_ACCOUNT);
        String userPasswordAccount = request.getParameter(USER_PASSWORD_ACCOUNT);
        String adminPassword = request.getParameter(ADMIN_PASSWORD);
        Group group = null;
        MembershipType membershipType = null;
        try {
            OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
            MembershipTypeHandler membershipTypeHandler = orgService.getMembershipTypeHandler();
            UserHandler userHandler = orgService.getUserHandler();
            User user = userHandler.createUserInstance(userNameAccount);
            user.setPassword(userPasswordAccount);
            user.setFirstName(firstNameAccount);
            user.setLastName(lastNameAccount);
            user.setEmail(emailAccount);
            try {
                userHandler.createUser(user, true);
            }
            catch (Exception e) {
                logger.error((Object)"Can not create User", (Throwable)e);
            }
            try {
                group = orgService.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                logger.error((Object)"Can not assign *:/platform/administrators membership to the created user", (Throwable)e);
            }
            try {
                group = orgService.getGroupHandler().findGroupById(PLATFORM_WEB_CONTRIBUTORS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                logger.error((Object)"Can not assign *:/platform/web-contributors membership to the created user", (Throwable)e);
            }
            try {
                group = orgService.getGroupHandler().findGroupById(PLATFORM_DEVELOPERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                logger.error((Object)"Can not assign *:/developers membership to the created user", (Throwable)e);
            }
            try {
                group = orgService.getGroupHandler().findGroupById(PLATFORM_PLATFORM_USERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                logger.error((Object)"Can not assign *:/platform/users membership to the created user", (Throwable)e);
            }
            try {
                User adminUser = userHandler.findUserByName(ADMIN_FIRST_NAME);
                adminUser.setPassword(adminPassword);
                orgService.getUserHandler().saveUser(adminUser, false);
            }
            catch (Exception e) {
                logger.error((Object)"Can not set password to the created user", (Throwable)e);
            }
        }
        finally {
            SettingService settingService_ = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
            if (settingService_.get(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE) == null) {
                settingService_.set(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE, SettingValue.create((String)"setup over:true"));
            }
            RequestLifeCycle.end();
        }
        String redirectURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/login?" + "username=" + URLEncoder.encode(userNameAccount, "UTF-8") + "&password=" + userPasswordAccount + "&initialURI=" + INTRANET_HOME;
        response.setCharacterEncoding("UTF-8");
        response.sendRedirect(redirectURI);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

