/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;

public class AccountSetupFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(AccountSetupFilter.class);
    SettingService settingService;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String edition = this.getPlatformEdition();
        boolean isDevMod = PropertyManager.isDevelopping();
        this.settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        boolean setupDone = false;
        SettingValue accountSetupNode = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "accountSetup");
        if (accountSetupNode != null) {
            setupDone = true;
        }
        if (!setupDone && !isDevMod) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.sendRedirect("/platform-extension/jsp/welcome-screens/accountSetup.jsp");
            return;
        }
        chain.doFilter(request, response);
    }

    private String getPlatformEdition() {
        try {
            Class<?> c = Class.forName("org.exoplatform.platform.edition.PlatformEdition");
            Method getEditionMethod = c.getMethod("getEdition", new Class[0]);
            String platformEdition = (String)getEditionMethod.invoke(null, new Object[0]);
            return platformEdition;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }
}

