/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.platform.common.navigation.NavigationUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/dashboards")
public class DashboardInformationRESTService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(DashboardInformationRESTService.class);
    protected static final String WS_ROOT_PATH = "/dashboards";
    protected static final String STANDALONE_ROOT_PATH = "/standalone";
    private final DataStorage dataStorageService;
    private final GadgetRegistryService gadgetRegistryService;
    private List<JsonGadgetInfo> gadgetsInfo;
    private NavigationService navigationService_;
    private DescriptionService descriptionService_;
    private PageNavigation navigation;

    public DashboardInformationRESTService(DataStorage dataStorageService, GadgetRegistryService gadgetRegistryService, DescriptionService descriptionService, NavigationService navigationService) {
        this.dataStorageService = dataStorageService;
        this.gadgetRegistryService = gadgetRegistryService;
        this.navigationService_ = navigationService;
        this.descriptionService_ = descriptionService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDashboards(@Context UriInfo uriInfo) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            LinkedList<JsonDashboardInfo> list = new LinkedList<JsonDashboardInfo>();
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            this.navigation = NavigationUtils.loadPageNavigation(userId, this.navigationService_, this.descriptionService_);
            ArrayList fragments = this.navigation.getFragments();
            for (NavigationFragment frag : fragments) {
                ArrayList pagesNode = frag.getNodes();
                String wsSubPath = "";
                String dashboardSubPath = "";
                URI wsURI = null;
                URI dashboardURI = null;
                for (PageNode pageNode : pagesNode) {
                    Application appDashboard = (Application)this.extractDashboard((Container)this.dataStorageService.getPage(pageNode.getPageReference()));
                    if (appDashboard == null || !(appDashboard.getState() instanceof TransientApplicationState)) continue;
                    JsonDashboardInfo info = new JsonDashboardInfo();
                    info.setId(pageNode.getName());
                    info.setLabel(pageNode.getLabel());
                    wsSubPath = PortalContainer.getCurrentRestContextName() + "/private" + WS_ROOT_PATH + "/" + userId + "/" + this.getPageName(pageNode.getPageReference());
                    wsURI = uriInfo.getBaseUriBuilder().replaceMatrix(wsSubPath).build(new Object[0]);
                    dashboardSubPath = PortalContainer.getCurrentPortalContainerName() + "/u/" + userId + "/" + pageNode.getName();
                    dashboardURI = uriInfo.getBaseUriBuilder().replaceMatrix(dashboardSubPath).build(new Object[0]);
                    info.setLink(wsURI.toString());
                    info.setHtml(dashboardURI.toString());
                    list.add(info);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting Dashboards Information");
            }
            return Response.ok(list, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while getting dashboards information.", (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{userName}/{dashboardName}")
    @Produces(value={"application/json"})
    public Response getGadgetInformation(@PathParam(value="userName") String userName, @PathParam(value="dashboardName") String dashboardName, @Context UriInfo uriInfo) {
        this.gadgetsInfo = new LinkedList<JsonGadgetInfo>();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            Application appDashboard;
            Page page;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Getting Gadgets Information");
            }
            if ((page = this.dataStorageService.getPage("user::" + userName + "::" + dashboardName)) != null && page.getChildren() != null && page.getChildren().size() > 0 && (appDashboard = (Application)this.extractDashboard((Container)page)) != null) {
                Dashboard dashboard = this.dataStorageService.loadDashboard(appDashboard.getStorageId());
                this.extractGadgets((Container)dashboard);
                int i = 0;
                String standaloneSubPath = "";
                URI standaloneURI = null;
                String iconSubPath = "";
                URI iconURI = null;
                for (JsonGadgetInfo info : this.gadgetsInfo) {
                    standaloneSubPath = info.getGadgetUrl();
                    standaloneURI = uriInfo.getBaseUriBuilder().replaceMatrix(standaloneSubPath).build(new Object[0]);
                    info.setGadgetUrl(standaloneURI.toString());
                    if (info.getGadgetIcon() != null && info.getGadgetIcon().length() > 0 && !info.getGadgetIcon().startsWith("http")) {
                        iconSubPath = info.getGadgetIcon();
                        iconURI = uriInfo.getBaseUriBuilder().replaceMatrix(iconSubPath).build(new Object[0]);
                        info.setGadgetIcon(iconURI.toString());
                    }
                    this.gadgetsInfo.set(i++, info);
                }
            }
            Response response = Response.ok(this.gadgetsInfo, (String)"application/json").cacheControl(cacheControl).build();
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while getting dashboards information.", (Throwable)e);
            Response response = Response.status((int)500).cacheControl(cacheControl).build();
            return response;
        }
        finally {
            try {
                RequestLifeCycle.end();
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception has occurred while proceed RequestLifeCycle.end() : " + e.getMessage()));
            }
        }
    }

    private void extractGadgets(Container container) throws Exception {
        ArrayList children;
        if (container != null && (children = container.getChildren()) != null) {
            for (ModelObject child : children) {
                if (child instanceof Application) {
                    Application application = (Application)child;
                    if (ApplicationType.GADGET != application.getType()) continue;
                    String gadgetName = this.dataStorageService.getId(application.getState());
                    Gadget gadget = this.gadgetRegistryService.getGadget(gadgetName);
                    if (gadget != null) {
                        JsonGadgetInfo info = new JsonGadgetInfo();
                        info.setGadgetName(gadget.getTitle());
                        info.setGadgetUrl(PortalContainer.getCurrentPortalContainerName() + STANDALONE_ROOT_PATH + "/" + application.getStorageId());
                        info.setGadgetIcon(gadget.getThumbnail());
                        info.setGadgetDescription(gadget.getDescription());
                        this.gadgetsInfo.add(info);
                        continue;
                    }
                    LOG.warn((Object)("Gadget with name " + gadgetName + " is no longer registered in Gadget Registry"));
                    continue;
                }
                if (!(child instanceof Container)) continue;
                Container childContainer = (Container)child;
                this.extractGadgets(childContainer);
            }
        }
    }

    private ModelObject extractDashboard(Container container) throws Exception {
        if (container != null) {
            ArrayList children = container.getChildren();
            for (ModelObject child : children) {
                if (child instanceof Application) {
                    Application application = (Application)child;
                    if (ApplicationType.PORTLET != application.getType()) continue;
                    return application;
                }
                if (!(child instanceof Container)) continue;
                Container childContainer = (Container)child;
                return this.extractDashboard(childContainer);
            }
        }
        return null;
    }

    private String getPageName(String pageRef) {
        String pageName = "";
        String[] refs = pageRef.split("::");
        pageName = refs[refs.length - 1];
        return pageName;
    }

    public static class JsonGadgetInfo {
        String gadgetName;
        String gadgetUrl;
        String gadgetIcon;
        String gadgetDescription;

        public String getGadgetName() {
            return this.gadgetName;
        }

        public void setGadgetName(String name) {
            this.gadgetName = name;
        }

        public String getGadgetUrl() {
            return this.gadgetUrl;
        }

        public void setGadgetUrl(String gadgetUrl) {
            this.gadgetUrl = gadgetUrl;
        }

        public String getGadgetIcon() {
            return this.gadgetIcon;
        }

        public void setGadgetIcon(String gadgetIcon) {
            this.gadgetIcon = gadgetIcon;
        }

        public String getGadgetDescription() {
            return this.gadgetDescription;
        }

        public void setGadgetDescription(String gadgetDescription) {
            this.gadgetDescription = gadgetDescription;
        }
    }

    public static class JsonDashboardInfo {
        String id;
        String label;
        String html;
        String link;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }
}

