/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.common.software.register.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PingBackServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getExoLogger(PingBackServlet.class);
    private static String pingBackUrl;
    private static final long serialVersionUID = 6467955354840693802L;
    private static boolean loopfuseFormDisplayed;
    public static final String LOOP_FUSE_FORM_DISPLAYED = "formDisplayed";
    public static final String COMMUNITY_EDITION = "community";
    private static String edition;

    public void init(ServletConfig servletConfig) throws ServletException {
        pingBackUrl = servletConfig.getInitParameter("pingBackUrl");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (PingBackServlet.isConnectedToInternet()) {
            loopfuseFormDisplayed = true;
            try {
                PingBackServlet.writePingBackFormDisplayed(loopfuseFormDisplayed);
            }
            catch (MissingProductInformationException e) {
                LOG.error("Product Information not found ", new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public static boolean isConnectedToInternet() {
        String pingServerURL = pingBackUrl.substring(0, pingBackUrl.indexOf("/", "http://url".length()));
        try {
            URL url = new URL(pingServerURL);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            return 404 != urlConn.getResponseCode();
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL));
        }
        catch (IOException e) {
            LOG.error((Object)("LeadCapture : Error creating HTTP connection to the server : " + pingServerURL));
        }
        return false;
    }

    public static void writeToFile(String key, String value, String fileLocation) {
        block10: {
            if (fileLocation == null || fileLocation.isEmpty()) {
                throw new IllegalArgumentException("Illegal empty file Location parameter.");
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Properties properties = new Properties();
                File file = new File(fileLocation);
                if (file.exists()) {
                    inputStream = new FileInputStream(fileLocation);
                    properties.loadFromXML(inputStream);
                    inputStream.close();
                } else {
                    PingBackServlet.verifyAndCreateParentFolder(fileLocation);
                }
                properties.put(key, value);
                outputStream = new FileOutputStream(fileLocation);
                properties.storeToXML(outputStream, "");
                outputStream.close();
            }
            catch (Exception exception) {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ioException) {
                        LOG.error((Object)"Error during close outputStream ", (Throwable)ioException);
                    }
                }
                if (inputStream == null) break block10;
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    LOG.error((Object)"Error during close inputStream ", (Throwable)ioException);
                }
            }
        }
    }

    private static void verifyAndCreateParentFolder(String fileLocation) {
        String parentFolderPath = fileLocation.replace("\\", "/");
        int parentFolderPathEndIndex = fileLocation.lastIndexOf("/");
        if (parentFolderPathEndIndex >= 0) {
            parentFolderPath = fileLocation.substring(0, parentFolderPathEndIndex);
        }
        if (!new File(parentFolderPath).exists()) {
            new File(parentFolderPath).mkdirs();
        }
    }

    public static void writePingBackFormDisplayed(boolean loopfuseFormDisplayed) throws MissingProductInformationException {
        PingBackServlet.loopfuseFormDisplayed = loopfuseFormDisplayed;
        PingBackServlet.writeToFile(LOOP_FUSE_FORM_DISPLAYED, Boolean.toString(loopfuseFormDisplayed), PingBackServlet.getPingBackFileLocation());
    }

    public static String getPingBackFileLocation() throws MissingProductInformationException {
        ProductInformations productInformations = (ProductInformations)PortalContainer.getInstance().getComponentInstanceOfType(ProductInformations.class);
        edition = PingBackServlet.getPlatformEdition(productInformations);
        if (edition != null && edition.equals(COMMUNITY_EDITION)) {
            return Utils.HOME_CONFIG_LOCATION + "/" + COMMUNITY_EDITION + ".xml";
        }
        return Utils.HOME_CONFIG_FILE_LOCATION;
    }

    public static String getPingBackUrl() {
        ProductInformations productInformations = (ProductInformations)PortalContainer.getInstance().getComponentInstanceOfType(ProductInformations.class);
        edition = PingBackServlet.getPlatformEdition(productInformations);
        boolean enterpriseCheck = false;
        if (edition.equalsIgnoreCase(COMMUNITY_EDITION)) {
            return pingBackUrl;
        }
        try {
            String loopfuseFormDisplayedString = PingBackServlet.readFromFile(LOOP_FUSE_FORM_DISPLAYED, PingBackServlet.getPingBackFileLocation());
            enterpriseCheck = Boolean.parseBoolean(loopfuseFormDisplayedString);
        }
        catch (Exception MissingProductInformationException2) {
            LOG.error((Object)"Platform version detection : Error loading the version from FileSystem, the default value will be used");
        }
        if (enterpriseCheck) {
            pingBackUrl = pingBackUrl.concat("-ent");
            return pingBackUrl;
        }
        pingBackUrl = pingBackUrl.concat("-ex");
        return pingBackUrl;
    }

    public static boolean isLandingPageDisplayed() throws MissingProductInformationException {
        String loopfuseFormDisplayedString = PingBackServlet.readFromFile(LOOP_FUSE_FORM_DISPLAYED, PingBackServlet.getPingBackFileLocation());
        if (loopfuseFormDisplayedString != null && !loopfuseFormDisplayedString.isEmpty()) {
            ProductInformations productInformations = (ProductInformations)PortalContainer.getInstance().getComponentInstanceOfType(ProductInformations.class);
            loopfuseFormDisplayed = Boolean.parseBoolean(loopfuseFormDisplayedString);
            if (PingBackServlet.getPlatformEdition(productInformations).equals("ENTERPRISE") && loopfuseFormDisplayed) {
                return false;
            }
        }
        return loopfuseFormDisplayed;
    }

    public static String readFromFile(String key, String fileLocation) throws MissingProductInformationException {
        if (fileLocation != null && !fileLocation.isEmpty() && !new File(fileLocation).exists()) {
            PingBackServlet.writePingBackFormDisplayed(false);
            return "false";
        }
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(fileLocation);
            properties.loadFromXML(inputStream);
            ((InputStream)inputStream).close();
            return (String)properties.get(key);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String getPlatformEdition(ProductInformations platformInformations) {
        try {
            Class<?> c = Class.forName("org.exoplatform.platform.edition.PlatformEdition");
            Method getEditionMethod = c.getMethod("getEdition", new Class[0]);
            String platformEdition = (String)getEditionMethod.invoke(null, new Object[0]);
            if (platformEdition != null && platformEdition.equals("enterprise") && platformInformations.getEdition() != null && !platformInformations.getEdition().equals("")) {
                platformEdition = platformInformations.getEdition();
            }
            return platformEdition;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }

    static {
        loopfuseFormDisplayed = false;
        edition = "";
    }
}

