/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.gatein.common.text.EntityEncoder;

public class AccountSetup
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(AccountSetup.class);
    private static final long serialVersionUID = 6467955354840693802L;
    public static final String ACCOUNT_SETUP_NODE = "accountSetup";
    private static final String USER_NAME_ACCOUNT = "username";
    private static final String FIRST_NAME_ACCOUNT = "firstNameAccount";
    private static final String LAST_NAME_ACCOUNT = "lastNameAccount";
    private static final String EMAIL_ACCOUNT = "emailAccount";
    private static final String USER_PASSWORD_ACCOUNT = "password";
    private static final String ADMIN_FIRST_NAME = "root";
    private static final String ADMIN_PASSWORD = "adminPassword";
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String PLATFORM_DEVELOPERS_GROUP = "/developers";
    private static final String PLATFORM_PLATFORM_USERS_GROUP = "/platform/users";
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private static final String INTRANET_HOME = "/portal/intranet";
    private static final String INITIAL_URI_PARAM = "initialURI";
    private static final String ACCOUNT_SETUP_BUTTON = "setupbutton";
    private static final String SETUP_SKIP_BUTTON = "skipform";
    public static Boolean SETUP_SKIP = false;
    private static final String ACCOUNT_SETUP_SKIP_PROPERTY = "accountsetup.skip";
    SettingService settingService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectURI = null;
        String accountsetupbutton = request.getParameter(ACCOUNT_SETUP_BUTTON);
        boolean isDevMod = PropertyManager.isDevelopping();
        String propertySetupSkip = PropertyManager.getProperty((String)ACCOUNT_SETUP_SKIP_PROPERTY);
        if (propertySetupSkip == null) {
            LOG.debug((Object)"Property accountsetup.skip not found in configuration.properties ");
            propertySetupSkip = "false";
        }
        this.settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        SettingValue accountSetupNode = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE);
        if (accountsetupbutton.equals(SETUP_SKIP_BUTTON) || accountSetupNode != null || propertySetupSkip.equals("true") || isDevMod) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Direct access to Account Setup Form.");
            }
            SETUP_SKIP = true;
            redirectURI = "/" + PortalContainer.getCurrentPortalContainerName();
        } else {
            EntityEncoder encoder = EntityEncoder.FULL;
            String userNameAccount = request.getParameter(USER_NAME_ACCOUNT);
            String firstNameAccount = request.getParameter(FIRST_NAME_ACCOUNT);
            String lastNameAccount = request.getParameter(LAST_NAME_ACCOUNT);
            String emailAccount = request.getParameter(EMAIL_ACCOUNT);
            String userPasswordAccount = request.getParameter(USER_PASSWORD_ACCOUNT);
            String adminPassword = request.getParameter(ADMIN_PASSWORD);
            Group group = null;
            MembershipType membershipType = null;
            try {
                OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
                RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
                MembershipTypeHandler membershipTypeHandler = orgService.getMembershipTypeHandler();
                UserHandler userHandler = orgService.getUserHandler();
                User user = userHandler.createUserInstance(userNameAccount);
                user.setPassword(userPasswordAccount);
                user.setFirstName(firstNameAccount);
                user.setLastName(lastNameAccount);
                user.setEmail(emailAccount);
                try {
                    userHandler.createUser(user, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not create User", (Throwable)e);
                }
                try {
                    group = orgService.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                    membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                    orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not assign *:/platform/administrators membership to the created user", (Throwable)e);
                }
                try {
                    group = orgService.getGroupHandler().findGroupById(PLATFORM_WEB_CONTRIBUTORS_GROUP);
                    membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                    orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not assign *:/platform/web-contributors membership to the created user", (Throwable)e);
                }
                try {
                    group = orgService.getGroupHandler().findGroupById(PLATFORM_DEVELOPERS_GROUP);
                    membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                    orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not assign *:/developers membership to the created user", (Throwable)e);
                }
                try {
                    group = orgService.getGroupHandler().findGroupById(PLATFORM_PLATFORM_USERS_GROUP);
                    membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                    orgService.getMembershipHandler().linkMembership(user, group, membershipType, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not assign *:/platform/users membership to the created user", (Throwable)e);
                }
                try {
                    User adminUser = userHandler.findUserByName(ADMIN_FIRST_NAME);
                    adminUser.setPassword(adminPassword);
                    orgService.getUserHandler().saveUser(adminUser, false);
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not set password to the created user", (Throwable)e);
                }
            }
            finally {
                if (accountSetupNode == null) {
                    this.settingService.set(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE, SettingValue.create((String)"setup over:true"));
                }
                RequestLifeCycle.end();
            }
            redirectURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/login?username=" + URLEncoder.encode(userNameAccount, "UTF-8") + "&password=" + userPasswordAccount + "&initialURI=" + INTRANET_HOME;
        }
        response.setCharacterEncoding("UTF-8");
        response.sendRedirect(redirectURI);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

