/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.FeatureToggles;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.service.LinkProvider;

@Path(value="/homepage/intranet/features/")
public class FeatureTogglesRestService
implements ResourceContainer {
    private static Log LOG = ExoLogger.getLogger(FeatureTogglesRestService.class);

    @GET
    public Response featureSwitch(@QueryParam(value="name") String featureName, @QueryParam(value="active") String active) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!acl.getSuperUser().equals(currentUser)) {
            LOG.warn((Object)"You don't have permission to switch a feature");
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        boolean isActive = !"no".equals(active);
        ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);
        featureService.saveActiveFeature(featureName, isActive);
        String domain = System.getProperty("gatein.email.domain.url", "http://localhost:8080");
        return Response.seeOther((URI)URI.create(domain + LinkProvider.getRedirectUri((String)""))).build();
    }
}

