/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.module.Module;
import org.exoplatform.platform.common.module.ModulePlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.picocontainer.Startable;

public class ModuleRegistry
implements Startable {
    public static final String ALL_MODULES_PROFILE = "all";
    private static final Log LOG = ExoLogger.getExoLogger(ModuleRegistry.class);
    private Map<String, Boolean> isPortletActiveCache = new ConcurrentHashMap<String, Boolean>();
    private boolean isPortletDisplayNamesImported = false;
    private Map<String, Module> modulesByName = new HashMap<String, Module>();
    private Map<String, Set<Module>> modulesByWebapp = new HashMap<String, Set<Module>>();
    private Map<String, Set<Module>> modulesByPortlet = new HashMap<String, Set<Module>>();
    private List<String> portletsManagedByProfile;
    private Map<String, LocalizedString> portletDisplayNames = new HashMap<String, LocalizedString>();

    public ModuleRegistry(InitParams initParams) {
        this.portletsManagedByProfile = initParams.containsKey((Object)"portlets.managed.by.profile") ? initParams.getValuesParam("portlets.managed.by.profile").getValues() : new ArrayList<String>();
        for (Module module : initParams.getObjectParamValues(Module.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)module.toString());
            }
            this.modulesByName.put(module.getName(), module);
        }
    }

    public void addModule(ModulePlugin modulePlugin) {
        if (modulePlugin != null && modulePlugin.getModule() != null) {
            this.modulesByName.put(modulePlugin.getModule().getName(), modulePlugin.getModule());
        }
    }

    public void start() {
        Collection<Module> modules = this.getAvailableModules();
        for (Module module : modules) {
            for (String webappName : module.getWebapps()) {
                Set<Module> webappModules = this.modulesByWebapp.get(webappName);
                if (webappModules == null) {
                    webappModules = new HashSet<Module>();
                    this.modulesByWebapp.put(webappName, webappModules);
                }
                webappModules.add(module);
            }
        }
        for (Module module : modules) {
            if (module.getPortlets() == null || module.getPortlets().isEmpty()) continue;
            for (String portletId : module.getPortlets()) {
                if (!portletId.contains("/")) {
                    LOG.warn((Object)(portletId + " isn't a valid portlet ID, it have to be something like: {webappName}/{portletName}."));
                    continue;
                }
                Set<Module> portletModules = this.modulesByPortlet.get(portletId);
                if (portletModules == null) {
                    String[] portletIdSplitted;
                    String webappName;
                    Set<Module> webappModules;
                    portletModules = new HashSet<Module>();
                    this.modulesByPortlet.put(portletId, portletModules);
                    if (!this.portletsManagedByProfile.contains(portletId) && (webappModules = this.modulesByWebapp.get(webappName = (portletIdSplitted = portletId.split("/"))[0])) != null && !webappModules.isEmpty()) {
                        portletModules.addAll(webappModules);
                    }
                }
                portletModules.add(module);
            }
        }
    }

    public String getDisplayName(String portletName, Locale locale) {
        String portletDisplayName = portletName;
        if (this.portletDisplayNames.get(portletName) != null) {
            portletDisplayName = this.portletDisplayNames.get(portletName).getValue(locale, true).getString();
        } else if (!this.isPortletDisplayNamesImported) {
            PortletInvoker portletInvoker = (PortletInvoker)PortalContainer.getComponent(PortletInvoker.class);
            try {
                Set portlets = portletInvoker.getPortlets();
                for (Portlet portlet : portlets) {
                    this.portletDisplayNames.put(portlet.getInfo().getName(), portlet.getInfo().getMeta().getMetaValue("display-name"));
                }
                this.isPortletDisplayNamesImported = true;
            }
            catch (PortletInvokerException exception) {
                LOG.error((Object)"Error occurred when trying to import portlets", (Throwable)exception);
            }
            if (this.portletDisplayNames.get(portletName) != null) {
                portletDisplayName = this.portletDisplayNames.get(portletName).getValue(locale, true).getString();
            }
        }
        return portletDisplayName;
    }

    public Set<String> getModulesForWebapp(String webappName) {
        HashSet<String> profileNames = new HashSet<String>();
        Set<Module> webappModules = this.modulesByWebapp.get(webappName);
        if (webappModules != null && !webappModules.isEmpty()) {
            for (Module module : webappModules) {
                profileNames.add(module.getName());
            }
        }
        profileNames.add(ALL_MODULES_PROFILE);
        return profileNames;
    }

    public Set<String> getModulesForPortlet(String portletId) {
        Set<String> profileNames = new HashSet<String>();
        Set<Module> portletModules = this.modulesByPortlet.get(portletId);
        if (portletModules == null || portletModules.isEmpty()) {
            if (!this.portletsManagedByProfile.contains(portletId)) {
                String[] portletIdSplitted = portletId.split("/");
                String webappName = portletIdSplitted[0];
                profileNames = this.getModulesForWebapp(webappName);
            }
        } else {
            for (Module module : portletModules) {
                profileNames.add(module.getName());
            }
        }
        profileNames.add(ALL_MODULES_PROFILE);
        return profileNames;
    }

    public boolean isPortletActive(String portletId) {
        Boolean isPortletActive = this.isPortletActiveCache.get(portletId);
        if (isPortletActive != null) {
            return isPortletActive;
        }
        Set<String> portletActiveProfiles = this.getModulesForPortlet(portletId);
        if (portletActiveProfiles.size() == 1 && portletActiveProfiles.contains(ALL_MODULES_PROFILE)) {
            isPortletActive = true;
        } else {
            Set currentActiveProfiles = PortalContainer.getProfiles();
            portletActiveProfiles.retainAll(currentActiveProfiles);
            isPortletActive = !portletActiveProfiles.isEmpty();
        }
        this.isPortletActiveCache.put(portletId, isPortletActive);
        return isPortletActive;
    }

    public void stop() {
    }

    private Collection<Module> getAvailableModules() {
        return this.modulesByName.values();
    }
}

