/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginCounterBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="loginhistory")
public class LoginHistoryRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(LoginHistoryRestService.class);
    private static final CacheControl cacheControl;
    protected final LoginHistoryService loginHistoryService;

    public LoginHistoryRestService(LoginHistoryService loginHistoryService) {
        this.loginHistoryService = loginHistoryService;
    }

    @GET
    @Path(value="/loginhistory/{userId}/{fromTime}/{toTime}")
    @Produces(value={"application/json"})
    public Response loginhistory(@PathParam(value="userId") String userId, @PathParam(value="fromTime") Long fromTime, @PathParam(value="toTime") Long toTime) throws Exception {
        try {
            List<LoginHistoryBean> loginHis = this.loginHistoryService.getLoginHistory(userId, fromTime, toTime);
            ArrayList<Object> loginHisData = new ArrayList<Object>();
            loginHisData.add(loginHis.size());
            loginHisData.add(loginHis);
            MessageBean data = new MessageBean();
            data.setData(loginHisData);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in get user login history REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/weekstats/{userId}/{week}")
    @Produces(value={"application/json"})
    public Response weekstats(@PathParam(value="userId") String userId, @PathParam(value="week") String week) throws Exception {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List<LoginCounterBean> loginCounts = this.loginHistoryService.getLoginCountPerDaysInWeek(userId, sdf.parse(week).getTime());
            ArrayList<Object> loginCountsData = new ArrayList<Object>();
            loginCountsData.add(loginCounts.size());
            loginCountsData.add(loginCounts);
            MessageBean data = new MessageBean();
            data.setData(loginCountsData);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in weekstats REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/monthstats/{userId}/{fromMonth}/{numOfMonths}")
    @Produces(value={"application/json"})
    public Response monthstats(@PathParam(value="userId") String userId, @PathParam(value="fromMonth") String fromMonth, @PathParam(value="numOfMonths") int numOfMonths) throws Exception {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List<LoginCounterBean> loginCounts = this.loginHistoryService.getLoginCountPerWeeksInMonths(userId, sdf.parse(fromMonth).getTime(), numOfMonths);
            ArrayList<Object> loginCountsData = new ArrayList<Object>();
            loginCountsData.add(loginCounts.size());
            loginCountsData.add(loginCounts);
            MessageBean data = new MessageBean();
            data.setData(loginCountsData);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in monthstats REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/yearstats/{userId}/{year}")
    @Produces(value={"application/json"})
    public Response yearstats(@PathParam(value="userId") String userId, @PathParam(value="year") String year) throws Exception {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            List<LoginCounterBean> loginCounts = this.loginHistoryService.getLoginCountPerMonthsInYear(userId, sdf.parse(year).getTime());
            ArrayList<Object> loginCountsData = new ArrayList<Object>();
            loginCountsData.add(loginCounts.size());
            loginCountsData.add(loginCounts);
            MessageBean data = new MessageBean();
            data.setData(loginCountsData);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in yearstats REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/lastlogins/{numItems}/{userIdFilter}")
    @Produces(value={"application/json"})
    public Response lastlogins(@PathParam(value="numItems") int numItems, @PathParam(value="userIdFilter") String userIdFilter) throws Exception {
        try {
            List<Object> lastLogins = this.loginHistoryService.getLastLogins(numItems, userIdFilter);
            MessageBean data = new MessageBean();
            data.setData(lastLogins);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in get last logins REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class MessageBean {
        private List<Object> data;

        public void setData(List<Object> list) {
            this.data = list;
        }

        public List<Object> getData() {
            return this.data;
        }
    }
}

