/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.container;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ExtendedPropertyConfigurator
extends PropertyConfigurator
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(ExtendedPropertyConfigurator.class);

    public ExtendedPropertyConfigurator(InitParams params, ConfigurationManager confManager) {
        super(ExtendedPropertyConfigurator.loadPropertiesParams(params), confManager);
        ValuesParam exts = params.getValuesParam("properties.urls");
        if (exts != null) {
            for (Object val : exts.getValues()) {
                String path = (String)val;
                if (path == null) continue;
                URL url = null;
                try {
                    url = confManager.getURL(path);
                    url.openStream().close();
                    LOG.info((Object)("Using property file " + url + " to set configuration properties."));
                    Map props = ContainerUtil.loadProperties((URL)url);
                    if (props == null) continue;
                    for (Map.Entry entry : props.entrySet()) {
                        String propertyName = (String)entry.getKey();
                        String propertyValue = (String)entry.getValue();
                        PropertyManager.setProperty((String)propertyName, (String)propertyValue);
                    }
                }
                catch (FileNotFoundException fne) {
                    LOG.info((Object)("Skipping configuration file " + path + ". File doesn't exist."));
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot load extension property file " + path + (url != null ? " resolved as " + url : "")), (Throwable)e);
                }
            }
        }
    }

    private static InitParams loadPropertiesParams(InitParams params) {
        if (params != null) {
            Iterator it = params.getPropertiesParamIterator();
            while (it.hasNext()) {
                PropertiesParam propertiesParam = (PropertiesParam)it.next();
                LOG.debug((Object)"Going to initialize properties from init param");
                Iterator i = propertiesParam.getPropertyIterator();
                while (i.hasNext()) {
                    Property property = (Property)i.next();
                    String name = property.getName();
                    String value = property.getValue();
                    LOG.debug((Object)("Adding property from init param " + name + " = " + value));
                    PropertyManager.setProperty((String)name, (String)value);
                }
                if (!"properties".equals(propertiesParam.getName())) continue;
                it.remove();
            }
        }
        return params;
    }

    public void start() {
    }

    public void stop() {
    }
}

