/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.service.plugin.MenuConfiguratorAddNodePlugin;
import org.exoplatform.platform.common.service.plugin.MenuConfiguratorRemoveNodePlugin;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class MenuConfiguratorService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(MenuConfiguratorService.class);
    private ConfigurationManager configurationManager;
    private String setupNavigationFilePath;
    private List<PageNode> setupPageNodes = new LinkedList<PageNode>();
    private List<MenuConfiguratorAddNodePlugin> menuConfiguratorAddNodePlugins = new ArrayList<MenuConfiguratorAddNodePlugin>();
    private List<MenuConfiguratorRemoveNodePlugin> menuConfiguratorRemoveNodePlugins = new ArrayList<MenuConfiguratorRemoveNodePlugin>();
    private UserNodeFilterConfig myGroupsFilterConfig;

    public MenuConfiguratorService(InitParams initParams, ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        if (!initParams.containsKey((Object)"setup.navigation.file")) {
            throw new IllegalStateException("Init param 'setup.navigation.file' have to be set.");
        }
        this.setupNavigationFilePath = initParams.getValueParam("setup.navigation.file").getValue();
    }

    public List<PageNode> getSetupMenuOriginalPageNodes() {
        return this.setupPageNodes;
    }

    public List<String> getSetupMenuPageReferences() {
        ArrayList<String> pageReferences = new ArrayList<String>();
        this.getPageReferences(pageReferences, this.setupPageNodes);
        return pageReferences;
    }

    public List<UserNode> getSetupMenuItems(UserPortal userPortal) throws Exception {
        ArrayList<UserNode> userNodes = new ArrayList<UserNode>();
        this.getSetupMenuItems(userPortal, userNodes, this.setupPageNodes);
        return userNodes;
    }

    public UserNodeFilterConfig getMyGroupsFilterConfig() {
        return this.myGroupsFilterConfig;
    }

    public void addNavigation(MenuConfiguratorAddNodePlugin plugin) {
        this.menuConfiguratorAddNodePlugins.add(plugin);
    }

    public void removeNavigation(MenuConfiguratorRemoveNodePlugin plugin) {
        this.menuConfiguratorRemoveNodePlugins.add(plugin);
    }

    public void start() {
        try {
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
            builder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
            builder.withTemporalCheck();
            this.myGroupsFilterConfig = builder.build();
            LOG.info((Object)("Loading setup menu configuration from: " + this.setupNavigationFilePath));
            UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)this.configurationManager.getInputStream(this.setupNavigationFilePath));
            PageNavigation pageNavigation = (PageNavigation)obj.getObject();
            NavigationFragment fragment = pageNavigation.getFragment();
            this.setupPageNodes = fragment.getNodes();
            for (MenuConfiguratorAddNodePlugin menuConfiguratorAddNodePlugin : this.menuConfiguratorAddNodePlugins) {
                menuConfiguratorAddNodePlugin.execute();
            }
            for (MenuConfiguratorRemoveNodePlugin menuConfiguratorRemoveNodePlugin : this.menuConfiguratorRemoveNodePlugins) {
                menuConfiguratorRemoveNodePlugin.execute();
            }
            for (PageNode pageNode : this.setupPageNodes) {
                MenuConfiguratorService.fixOwnerName(pageNode);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unknown error occurred when setting Setup menu items.", e);
        }
    }

    public void stop() {
    }

    private void getPageReferences(List<String> pageReferences, List<PageNode> pageNodes) {
        for (PageNode pageNode : pageNodes) {
            String pageReference = pageNode.getPageReference();
            if (pageReference != null && !pageReference.isEmpty()) {
                pageReferences.add(pageReference);
            }
            if (pageNode.getChildren() == null || pageNode.getChildren().isEmpty()) continue;
            this.getPageReferences(pageReferences, pageNode.getChildren());
        }
    }

    private void getSetupMenuItems(UserPortal userPortal, List<UserNode> userNodes, List<PageNode> setupPageNodes) {
        for (PageNode pageNode : setupPageNodes) {
            String pageReference = pageNode.getPageReference();
            UserNavigation userNavigation = userPortal.getNavigation(new SiteKey(this.getOwnerType(pageReference), this.getOwnerName(pageReference)));
            UserNode userNode = this.searchUserNodeByPageReference(userPortal, userNavigation, pageReference);
            if (userNode != null) {
                userNodes.add(userNode);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Can't find a navigation with pageReference: " + pageReference));
            }
            if (pageNode.getChildren() == null || pageNode.getChildren().isEmpty()) continue;
            this.getSetupMenuItems(userPortal, userNodes, pageNode.getChildren());
        }
    }

    private UserNode searchUserNodeByPageReference(UserPortal userPortal, UserNavigation nav, String pageReference) {
        if (nav != null) {
            try {
                UserNode rootNode = userPortal.getNode(nav, Scope.ALL, this.myGroupsFilterConfig, null);
                if (rootNode.getPageRef() != null && pageReference.equals(rootNode.getPageRef())) {
                    return rootNode;
                }
                if (rootNode.getChildren() != null && !rootNode.getChildren().isEmpty()) {
                    return this.searchUserNodeByPageReference(rootNode.getChildren(), pageReference);
                }
            }
            catch (Exception exp) {
                LOG.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return null;
    }

    private UserNode searchUserNodeByPageReference(Collection<UserNode> userNodes, String pageReference) {
        if (userNodes == null || userNodes.isEmpty()) {
            return null;
        }
        for (UserNode userNode : userNodes) {
            UserNode childNode;
            if (userNode.getPageRef() != null && userNode.getPageRef().format().equals(pageReference)) {
                return userNode;
            }
            if (userNode.getChildren() == null || userNode.getChildren().isEmpty() || (childNode = this.searchUserNodeByPageReference(userNode.getChildren(), pageReference)) == null) continue;
            return childNode;
        }
        return null;
    }

    private String getOwnerType(String pageReference) {
        String[] pageIds = pageReference.split("::");
        return pageIds[0];
    }

    private String getOwnerName(String pageReference) {
        String[] pageIds = pageReference.split("::");
        return pageIds[1];
    }

    private static void fixOwnerName(PageNode pageNode) {
        if (pageNode.getPageReference() != null) {
            String pageRef = pageNode.getPageReference();
            int pos1 = pageRef.indexOf("::");
            int pos2 = pageRef.indexOf("::", pos1 + 2);
            String type = pageRef.substring(0, pos1);
            String owner = pageRef.substring(pos1 + 2, pos2);
            String name = pageRef.substring(pos2 + 2);
            owner = MenuConfiguratorService.fixOwnerName(type, owner);
            pageRef = type + "::" + owner + "::" + name;
            pageNode.setPageReference(pageRef);
        }
        if (pageNode.getNodes() != null) {
            for (PageNode childPageNode : pageNode.getNodes()) {
                MenuConfiguratorService.fixOwnerName(childPageNode);
            }
        }
    }

    private static String fixOwnerName(String type, String owner) {
        if (type.equals(PortalConfig.GROUP_TYPE) && !owner.startsWith("/")) {
            return "/" + owner;
        }
        return owner;
    }
}

