/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.software.register.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.common.software.register.UnlockService;
import org.exoplatform.platform.common.software.register.service.SoftwareRegistrationService;
import org.exoplatform.web.filter.Filter;

public class SoftwareRegisterFilter
implements Filter {
    public static final String NOT_REACHABLE = "NOT_REACHABLE";
    private static final String PLF_COMMUNITY_SERVLET_CTX = "/registration";
    private static final String SR_SERVLET_URL = "/software-register";
    private static final String INITIAL_URI_PARAM_NAME = "initialURI";
    private SoftwareRegistrationService plfRegisterService = (SoftwareRegistrationService)PortalContainer.getInstance().getComponentInstanceOfType(SoftwareRegistrationService.class);
    private UnlockService unlockService = (UnlockService)PortalContainer.getInstance().getComponentInstanceOfType(UnlockService.class);

    private boolean checkRequest(boolean requestSkip) {
        if (!requestSkip) {
            return true;
        }
        if (this.plfRegisterService.canSkipRegister() || this.unlockService.isUnlocked()) {
            return false;
        }
        return !this.plfRegisterService.canSkipRegister();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUri;
        boolean isRestUri;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        this.plfRegisterService = (SoftwareRegistrationService)PortalContainer.getInstance().getComponentInstanceOfType(SoftwareRegistrationService.class);
        boolean requestSkip = this.plfRegisterService.isRequestSkip();
        String notReachable = (String)httpServletRequest.getSession().getAttribute("notReachable");
        boolean isDevMod = PropertyManager.isDevelopping();
        if (notReachable == null) {
            notReachable = httpServletRequest.getQueryString();
            if (StringUtils.equals((String)notReachable, (String)NOT_REACHABLE)) {
                notReachable = "true";
                httpServletRequest.getSession().setAttribute("notReachable", (Object)notReachable);
            }
        }
        if (!((isRestUri = (requestUri = httpServletRequest.getRequestURI()).contains(ExoContainerContext.getCurrentContainer().getContext().getRestContextName())) || this.plfRegisterService.isSoftwareRegistered() || isDevMod || StringUtils.equals((String)notReachable, (String)"true") || !this.checkRequest(requestSkip) || this.plfRegisterService.isSkipPlatformRegistration())) {
            String reqUri = httpServletRequest.getRequestURI().toString();
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null) {
                reqUri = new StringBuffer(reqUri).append("?").append(queryString).toString();
            }
            ServletContext platformRegisterContext = httpServletRequest.getSession().getServletContext().getContext(PLF_COMMUNITY_SERVLET_CTX);
            String uriTarget = SR_SERVLET_URL + "?" + INITIAL_URI_PARAM_NAME + "=" + reqUri;
            platformRegisterContext.getRequestDispatcher(uriTarget).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        chain.doFilter(request, response);
    }
}

