/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.branding;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.branding.BrandingService;
import org.exoplatform.platform.common.branding.Logo;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BrandingUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(BrandingUpgradePlugin.class);
    private static final String path = "Application Data/logos/";
    private static final String logo_name = "logo.png";
    private static final String WORKSPACE_COLLABORATION = "collaboration";
    private RepositoryService repositoryService;
    private BrandingService brandingService;

    public BrandingUpgradePlugin(InitParams initParams, RepositoryService repositoryService, BrandingService brandingService) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.brandingService = brandingService;
    }

    public void processUpgrade(String newVersion, String previousVersion) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        if (!this.hasDataToMigrate().booleanValue()) {
            LOG.info((Object)"== No Branding data to migrate from JCR");
        } else {
            LOG.info((Object)"== Start migration of Branding data from JCR");
            try {
                Session session = this.getSession(sProvider);
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode(path)) {
                    Node logosNode = rootNode.getNode(path);
                    if (logosNode.hasNode(logo_name)) {
                        Node logoNode = logosNode.getNode(logo_name);
                        if (logoNode.hasNode("jcr:content")) {
                            Node logoContent = logoNode.getNode("jcr:content");
                            Property data = logoContent.getProperty("jcr:data");
                            Logo logo = new Logo();
                            byte[] logoData = IOUtils.toByteArray((InputStream)data.getStream());
                            logo.setData(logoData);
                            logo.setSize(logoData.length);
                            this.brandingService.updateLogo(logo);
                        }
                        logoNode.remove();
                        session.save();
                    }
                    this.removeLogoHome();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("== Branding Data migration - Error when migrating logo from JCR", e);
            }
            finally {
                sProvider.close();
            }
            LOG.info((Object)"==    Branding Data migration - Branding Data migration successfully !");
            LOG.info((Object)"== Migration Branding Data done");
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this.repositoryService.getCurrentRepository();
        return sessionProvider.getSession(WORKSPACE_COLLABORATION, currentRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean hasDataToMigrate() {
        boolean hasDataToMigrate = false;
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node logosNode;
            Session session = this.getSession(sProvider);
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(path) && (logosNode = rootNode.getNode(path)).hasNode(logo_name)) {
                hasDataToMigrate = true;
            }
        }
        return hasDataToMigrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLogoHome() throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.getSession(sProvider);
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(path)) {
                rootNode.getNode(path).remove();
            }
        }
    }
}

