/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.favorite;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.utils.comparator.PropertyValueComparator;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONObject;

@Path(value="/plf/favorite/")
public class FavoriteRESTService
implements ResourceContainer {
    private static final String DATE_MODIFIED = "exo:dateModified";
    private static final String TITLE = "exo:title";
    private static final int NO_PER_PAGE = 10;
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Log LOG = ExoLogger.getLogger((String)FavoriteRESTService.class.getName());
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};

    @GET
    @Path(value="/get-documents/{userName}")
    public Response getFavoriteByUser(@PathParam(value="userName") String userName, @QueryParam(value="showItems") String showItems) throws Exception {
        ArrayList<FavoriteNode> listFavorites = new ArrayList<FavoriteNode>();
        ArrayList<Node> listNodes = new ArrayList<Node>();
        if (showItems == null || showItems.trim().length() == 0) {
            showItems = String.valueOf(10);
        }
        try {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProviderService.getSystemSessionProvider(null), userName);
            Node privateDrive = userNode.getNode("Private");
            Node publicDrive = userNode.getNode("Public");
            this.getListDocument(privateDrive, listNodes);
            this.getListDocument(publicDrive, listNodes);
            Collections.sort(listNodes, new PropertyValueComparator(DATE_MODIFIED, "Descending"));
            for (Node favorite : listNodes) {
                FavoriteNode favoriteNode = new FavoriteNode();
                favoriteNode.setName(favorite.getName());
                favoriteNode.setTitle(this.getTitle(favorite));
                favoriteNode.setDateAddFavorite(this.getDateFormat(favorite.getProperty(DATE_MODIFIED).getDate()));
                favoriteNode.setNodePath(favorite.getPath());
                String linkImage = "Icon16x16 default16x16Icon" + FavoriteRESTService.getNodeTypeIcon(favorite, "16x16Icon");
                favoriteNode.setLinkImage(linkImage);
                if (favoriteNode == null || listFavorites.size() >= Integer.valueOf(showItems)) continue;
                listFavorites.add(favoriteNode);
            }
        }
        catch (ItemNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
        ListResultNode listResultNode = new ListResultNode();
        listResultNode.setListFavorite(listFavorites);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)listResultNode, (MediaType)new MediaType("application", "json")).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/all/{repoName}/{workspaceName}/{userName}")
    public Response getFavoriteByUser(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="userName") String userName, @QueryParam(value="showItems") String showItems) throws Exception {
        ArrayList<FavoriteNode> listFavorites = new ArrayList<FavoriteNode>();
        if (showItems == null || showItems.trim().length() == 0) {
            showItems = String.valueOf(10);
        }
        try {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProviderService.getSystemSessionProvider(null), userName);
            List<Node> listNodes = this.getAllFavoritesByUser(wsName, repoName, userNode);
            Collections.sort(listNodes, new PropertyValueComparator(DATE_MODIFIED, "Descending"));
            for (Node favorite : listNodes) {
                FavoriteNode favoriteNode = new FavoriteNode();
                favoriteNode.setName(favorite.getName());
                favoriteNode.setTitle(this.getTitle(favorite));
                favoriteNode.setDateAddFavorite(this.getDateFormat(favorite.getProperty(DATE_MODIFIED).getDate()));
                favoriteNode.setNodePath(favorite.getPath());
                String linkImage = "Icon16x16 default16x16Icon" + FavoriteRESTService.getNodeTypeIcon(favorite, "16x16Icon");
                favoriteNode.setLinkImage(linkImage);
                if (favoriteNode == null || listFavorites.size() >= Integer.valueOf(showItems)) continue;
                listFavorites.add(favoriteNode);
            }
        }
        catch (ItemNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
        ListResultNode listResultNode = new ListResultNode();
        listResultNode.setListFavorite(listFavorites);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)listResultNode, (MediaType)new MediaType("application", "json")).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/favorite-folder/{userName}")
    public Response getFavoriteNode(@PathParam(value="userName") String userName) throws Exception {
        try {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
            Node userNode = nodeHierarchyCreator.getUserNode(sessionProviderService.getSystemSessionProvider(null), userName);
            Node favoriteNode = userNode.getNode("Private/Favorites");
            JSONObject json = new JSONObject();
            json.put("name", (Object)"favoriteNode");
            json.put("value", (Object)favoriteNode.getPath());
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            return Response.ok((Object)json.toString(), (String)"application/json").header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        if (node == null) {
            return "";
        }
        String nodeType = node.getPrimaryNodeType().getName();
        if (node.isNodeType("exo:symlink")) {
            LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
            try {
                nodeType = node.getProperty("exo:primaryType").getString();
                node = linkManager.getTarget(node);
                if (node == null) {
                    return "";
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        nodeType = nodeType.replace(':', '_') + appended;
        str.append(nodeType);
        str.append(" ");
        str.append("default16x16Icon");
        if (node.isNodeType("nt:file") && node.hasNode("jcr:content")) {
            Node jcrContentNode = node.getNode("jcr:content");
            str.append(' ').append(jcrContentNode.getProperty("jcr:mimeType").getString().replaceAll("/|\\.", "_")).append(appended);
        }
        return str.toString();
    }

    public void getListDocument(Node node, List<Node> listNodes) throws RepositoryException {
        LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
        String primaryType = node.getProperty("jcr:primaryType").getString();
        if (primaryType.contains("nt:file") || linkManager.isLink((Item)node)) {
            listNodes.add(node);
            return;
        }
        if (node.hasNodes()) {
            NodeIterator childNodes = node.getNodes();
            while (childNodes.hasNext()) {
                Node childNode = childNodes.nextNode();
                this.getListDocument(childNode, listNodes);
            }
        }
    }

    public List<Node> getAllFavoritesByUser(String workspace, String repository, Node userNode) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String favoritePath = nodeHierarchyCreator.getJcrPath("userPrivateFavorites");
        Node favoriteFolder = userNode.getNode(favoritePath);
        NodeIterator nodeIter = favoriteFolder.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            String primaryType = childNode.getProperty("jcr:primaryType").getString();
            if (!linkManager.isLink((Item)childNode) && !primaryType.contains("nt:file")) continue;
            ret.add(childNode);
        }
        return ret;
    }

    private String getTitle(Node node) throws Exception {
        if (node.hasProperty(TITLE)) {
            return node.getProperty(TITLE).getString();
        }
        return node.getName();
    }

    private String getDateFormat(Calendar date) {
        return String.valueOf(date.getTimeInMillis());
    }

    public class FavoriteNode {
        private String name;
        private String nodePath;
        private String dateAddFavorite;
        private String title;
        private String linkImage;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNodePath(String nodePath) {
            this.nodePath = nodePath;
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public void setDateAddFavorite(String dateAddFavorite) {
            this.dateAddFavorite = dateAddFavorite;
        }

        public String getDateAddFavorite() {
            return this.dateAddFavorite;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setLinkImage(String linkImage) {
            this.linkImage = linkImage;
        }

        public String getLinkImage() {
            return this.linkImage;
        }
    }

    public class ListResultNode {
        private List<? extends FavoriteNode> listFavorite;

        public List<? extends FavoriteNode> getListFavorite() {
            return this.listFavorite;
        }

        public void setListFavorite(List<? extends FavoriteNode> listFavorite) {
            this.listFavorite = listFavorite;
        }
    }
}

