/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.newspaces;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.newspaces.IntranetSpace;
import org.exoplatform.platform.gadget.services.newspaces.IntranetSpaceService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

@Path(value="intranetNewSpaceService")
public class NewSpaceRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NewSpaceRestService.class);
    public static final String REGISTRATION_OPEN = "open";
    public static final String REGISTRATION_VALIDATION = "validation";
    public static final String REGISTRATION_CLOSE = "close";
    public static final String VISIBILITY_PRIVATE = "private";
    public static final String VISIBILITY_HIDDEN = "hidden";

    @GET
    @Path(value="/space/latestCreatedSpace/{maxtime}/{language}")
    @Produces(value={"application/json"})
    public Response latestCreatedSocialSpace(@PathParam(value="maxtime") int maxtime, @PathParam(value="language") String language) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        IntranetSpaceService intranetSpaceService = (IntranetSpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IntranetSpaceService.class);
        List<Object> listIntranetSpace = new ArrayList();
        ArrayList<IntranetSpace> listResponseIntranetSpace = new ArrayList<IntranetSpace>();
        List<String> allGroupAndMembershipOfUser = this.getAllGroupAndMembershipOfUser();
        try {
            listIntranetSpace = intranetSpaceService.getLatestCreatedSpace(maxtime, language, allGroupAndMembershipOfUser);
            for (IntranetSpace intranetSpace : listIntranetSpace) {
                if (intranetSpace.getIsMember().booleanValue() || intranetSpace.getIsInvitedUser().booleanValue() || intranetSpace.getIsPendingUser().booleanValue()) {
                    listResponseIntranetSpace.add(intranetSpace);
                    continue;
                }
                if (!intranetSpace.getVisibility().equalsIgnoreCase(VISIBILITY_PRIVATE) || !intranetSpace.getRegistration().equalsIgnoreCase(REGISTRATION_OPEN) && !intranetSpace.getRegistration().equalsIgnoreCase(REGISTRATION_VALIDATION)) continue;
                listResponseIntranetSpace.add(intranetSpace);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"has not any space", (Throwable)e);
        }
        ArrayList<Object> dataIntranetSpace = new ArrayList<Object>();
        dataIntranetSpace.add(listResponseIntranetSpace);
        MessageBean messageBean = new MessageBean();
        messageBean.setData(dataIntranetSpace);
        return Response.ok((Object)messageBean, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/space/requestJoinSpace/{spaceUrl}")
    @Produces(value={"application/json"})
    public Response requestJoinSpace(@PathParam(value="spaceUrl") String spaceUrl) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        IntranetSpaceService intranetSpaceService = (IntranetSpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IntranetSpaceService.class);
        List<Object> listResponseIntranetSpace = new ArrayList();
        try {
            listResponseIntranetSpace = intranetSpaceService.requestToJoinOpenSpace(spaceUrl, this.getUserId());
        }
        catch (Exception e) {
            LOG.error((Object)"has not any space", (Throwable)e);
        }
        ArrayList<Object> dataIntranetSpace = new ArrayList<Object>();
        dataIntranetSpace.add(listResponseIntranetSpace);
        MessageBean data = new MessageBean();
        data.setData(dataIntranetSpace);
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    private List<String> getAllGroupAndMembershipOfUser() {
        ArrayList<String> listOfUser = new ArrayList<String>();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (identity.getGroups() == null || identity.getGroups().size() == 0) {
                return listOfUser;
            }
            listOfUser.add(identity.getUserId());
            HashSet<String> list = new HashSet<String>();
            list.addAll(identity.getGroups());
            for (MembershipEntry membership : identity.getMemberships()) {
                String value = membership.getGroup();
                list.add(value);
                value = new StringBuffer().append(membership.getMembershipType()).append(":").append(value).toString();
                list.add(value);
            }
            listOfUser.addAll(list);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to add all info of user.");
        }
        return listOfUser;
    }

    private String getUserId() {
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (identity.getGroups() == null || identity.getGroups().size() == 0) {
            return null;
        }
        return identity.getUserId();
    }

    public class MessageBean {
        private List<Object> data;

        public void setData(List<Object> list) {
            this.data = list;
        }

        public List<Object> getData() {
            return this.data;
        }
    }
}

