/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component.jmxclient;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class CommandHandler {
    public static final Logger logger = Logger.getAnonymousLogger();
    public static Map<String, Object> environmentMap = null;
    public static String hostname;
    public static String hostport;
    public static String beanName;
    public static String command;
    public static String[] mBeanArguments;

    public static void main(String[] args) {
        block7: {
            try {
                if (args.length < 4) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("<HOST_NAME> <HOST_PORT> -u<USER>(Optionnal) -p<PASSWORD>(Optionnal) <BEAN_NAME> <OPERATION_NAME> <OPERATION_ARG_1> <OPERATION_ARG_2>...");
                    }
                    return;
                }
                CommandHandler.extractArguments(args);
                JMXConnector jmxConnector = CommandHandler.connectToJMXServer();
                MBeanServerConnection serverConnection = jmxConnector.getMBeanServerConnection();
                ObjectName objectName = beanName != null && beanName.length() > 0 ? new ObjectName(beanName) : null;
                Set<ObjectInstance> beans = serverConnection.queryMBeans(objectName, null);
                if (beans.size() == 1) {
                    ObjectInstance instance = beans.iterator().next();
                    CommandHandler.invokeOperation(serverConnection, instance, command, mBeanArguments);
                } else if (logger.isLoggable(Level.INFO)) {
                    logger.info("Cannot find bean: " + objectName.getCanonicalName());
                }
                jmxConnector.close();
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.INFO)) break block7;
                logger.info(exception.getMessage());
            }
        }
    }

    public static void extractArguments(String[] args) {
        hostname = args[0];
        hostport = args[1];
        int argsIndex = 4;
        if (args[2].contains("-u")) {
            environmentMap = new HashMap<String, Object>(1);
            environmentMap.put("jmx.remote.credentials", new String[]{args[2].substring(2), args[3].substring(2)});
            argsIndex = 6;
        }
        beanName = args[argsIndex - 2];
        command = args[argsIndex - 1];
        mBeanArguments = null;
        if (args.length > argsIndex) {
            mBeanArguments = Arrays.copyOfRange(args, argsIndex, args.length);
        }
    }

    private static JMXConnector connectToJMXServer() throws MalformedURLException, IOException {
        JMXServiceURL jmxServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostname + ":" + hostport + "/jmxrmi");
        JMXConnector jmxConnector = environmentMap == null ? JMXConnectorFactory.connect(jmxServiceURL) : JMXConnectorFactory.connect(jmxServiceURL, environmentMap);
        return jmxConnector;
    }

    public static void invokeOperation(MBeanServerConnection mbsc, ObjectInstance instance, String command, String[] mBeanArguments) throws Exception {
        MBeanOperationInfo[] beanOperationInfos = mbsc.getMBeanInfo(instance.getObjectName()).getOperations();
        MBeanOperationInfo beanOperationInfo = null;
        for (MBeanOperationInfo beanOperationInfoTmp : beanOperationInfos) {
            if (!beanOperationInfoTmp.getName().equals(command)) continue;
            beanOperationInfo = beanOperationInfoTmp;
        }
        if (beanOperationInfo == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Operation (" + command + ") not found in bean(" + instance.getObjectName() + ")\n list of available operations: ");
            }
            for (MBeanOperationInfo beanOperationInfoTmp : beanOperationInfos) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info(beanOperationInfoTmp.getName());
            }
        } else {
            int argumentsLength;
            MBeanParameterInfo[] paraminfos = beanOperationInfo.getSignature();
            int paramsLength = paraminfos != null ? paraminfos.length : 0;
            int n = argumentsLength = mBeanArguments != null ? mBeanArguments.length : 0;
            if (paramsLength == argumentsLength) {
                String[] signature = new String[paramsLength];
                Object[] params = paramsLength != 0 ? new Object[paramsLength] : null;
                for (int i = 0; i < paraminfos.length; ++i) {
                    MBeanParameterInfo paraminfo = paraminfos[i];
                    Constructor<?> c = Class.forName(paraminfo.getType()).getConstructor(String.class);
                    params[i] = c.newInstance(mBeanArguments[i]);
                    signature[i] = paraminfo.getType();
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Invocation response: " + mbsc.invoke(instance.getObjectName(), command, params, signature));
                }
            } else if (logger.isLoggable(Level.INFO)) {
                logger.info("Parameters does not match operation signature");
            }
        }
    }
}

