/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.PlatformUpgradeUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeUserSiteLayoutPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeUserSiteLayoutPlugin.class);
    private static final String USER_SITE_TEMPLATE_NAME = "user.site.template.name";
    private static final String USER_SITE_TEMPLATE_LOACTION = "user.site.template.location";
    private DataStorage dataStorage_;
    protected String userSiteTemplateName;
    protected String userSiteTemplateLocation;

    public UpgradeUserSiteLayoutPlugin(DataStorage dataStorage, InitParams initParams) {
        super(initParams);
        this.dataStorage_ = dataStorage;
        this.userSiteTemplateName = initParams.getValueParam(USER_SITE_TEMPLATE_NAME).getValue();
        this.userSiteTemplateLocation = initParams.getValueParam(USER_SITE_TEMPLATE_LOACTION).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Query query = new Query(this.userSiteTemplateName, null, PortalConfig.class);
            LazyPageList usersPortalConfig = this.dataStorage_.find(query);
            if (usersPortalConfig == null) {
                LOG.info((Object)"No USER Site was found, no upgrade operation will be done.");
                return;
            }
            PortalConfig tempPortalConfig = PlatformUpgradeUtils.getPortalConfigFromTemplate(PortalConfig.USER_TYPE, this.userSiteTemplateName, this.userSiteTemplateLocation);
            for (PortalConfig userPortalConfig : usersPortalConfig.getAll()) {
                LOG.info((Object)("Proceed user site layout migration: " + userPortalConfig.getName()));
                PortalConfig newPortalConfig = new PortalConfig(PortalConfig.USER_TYPE, userPortalConfig.getName(), userPortalConfig.getStorageId());
                newPortalConfig.setStorageName(userPortalConfig.getStorageName());
                newPortalConfig.setName(userPortalConfig.getName());
                newPortalConfig.setAccessPermissions(userPortalConfig.getAccessPermissions());
                newPortalConfig.setDescription(userPortalConfig.getDescription());
                newPortalConfig.setEditPermission(userPortalConfig.getEditPermission());
                newPortalConfig.setLabel(userPortalConfig.getLabel());
                newPortalConfig.setModifiable(newPortalConfig.isModifiable());
                newPortalConfig.setPortalLayout(tempPortalConfig.getPortalLayout());
                newPortalConfig.setPortalRedirects(userPortalConfig.getPortalRedirects());
                newPortalConfig.setType(userPortalConfig.getType());
                this.dataStorage_.save(newPortalConfig);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error during USER Layout migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

