/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;

public class PLFSecureJCRFoldersUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)PLFSecureJCRFoldersUpgradePlugin.class.getName());
    private static final String HOME = "exo:LoginHistoryHome";
    private RepositoryService repoService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private SessionProvider sessionProvider;

    public PLFSecureJCRFoldersUpgradePlugin(RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, InitParams initParams) {
        super(initParams);
        this.repoService = repoService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.migrateCollaboration(sessionProvider);
        this.migrateGadgets(sessionProvider);
        this.migrateUsers(sessionProvider);
        this.migrateLoginHistory(sessionProvider);
        sessionProvider.close();
    }

    private void migrateCollaboration(SessionProvider sessionProvider) {
        block2: {
            try {
                String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
                Node node = session.getRootNode();
                ((ExtendedNode)node).removePermission(IdentityConstants.ANY);
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An unexpected error occurs when migrate Collaboration workspace", (Throwable)e);
            }
        }
    }

    private void migrateGadgets(SessionProvider sessionProvider) {
        block2: {
            try {
                Session session = sessionProvider.getSession("portal-system", this.repoService.getCurrentRepository());
                Node node = (Node)session.getItem("/production/app:gadgets");
                ((ExtendedNode)node).removePermission(IdentityConstants.ANY);
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An unexpected error occurs when migrate /production/app:gadgets", (Throwable)e);
            }
        }
    }

    private void migrateUsers(SessionProvider sessionProvider) {
        block2: {
            try {
                String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
                Node groups = (Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("usersPath"));
                ((ExtendedNode)groups).removePermission("*:/platform/users");
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An unexpected error occurs when migrate /Users", (Throwable)e);
            }
        }
    }

    private void migrateLoginHistory(SessionProvider sessionProvider) {
        block3: {
            try {
                String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode(HOME)) {
                    Node node = rootNode.getNode(HOME);
                    ((ExtendedNode)node).removePermission("*:/platform/users");
                }
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"An unexpected error occurs when migrate /exo:LoginHistoryHome", (Throwable)e);
            }
        }
    }
}

