/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Future;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.AbstractGadgetToPortletPlugin;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class UpgradeUserPortalPlugin
extends AbstractGadgetToPortletPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeUserPortalPlugin.class);
    private OrganizationService orgService;

    public UpgradeUserPortalPlugin(SettingService settingService, ModelDataStorage modelDataStorage, PageService pageService, NavigationService navigationService, OrganizationService orgService, RepositoryService repoService, InitParams initParams) {
        super(settingService, modelDataStorage, pageService, navigationService, repoService, initParams);
        this.orgService = orgService;
    }

    public UpgradeUserPortalPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Migrate Gadgets on user sites layout");
        this.migratePortals(SiteType.USER);
        this.cleanupUserNavs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUserNavs() {
        int size = 0;
        try {
            Set<PortalKey> portals = this.findUserSites();
            size = portals.size();
            LOG.info((Object)("START remove navigations/pages for " + size + " user sites"));
            PortalContainer container = PortalContainer.getInstance();
            RequestLifeCycle.begin((ExoContainer)container);
            ArrayList futures = new ArrayList();
            for (PortalKey portalKey : portals) {
                Runnable task = () -> {
                    try {
                        ExoContainerContext.setCurrentContainer((ExoContainer)container);
                        RequestLifeCycle.begin((ExoContainer)container);
                        LOG.info((Object)("START clean up navigations and pages of user site: " + key.getId()));
                        PortalData portal = this.modelDataStorage.getPortalConfig(key);
                        if (portal == null) {
                            LOG.info((Object)("Site for user " + key.getId() + " does not exists"));
                        } else {
                            NavigationContext navContext = this.navigationService.loadNavigation(SiteKey.user((String)key.getId()));
                            this.removeNavs(navContext);
                        }
                        LOG.info((Object)("DONE clean up navigations and pages for user site: " + key.getId()));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Error while clean up page/navigation of user: " + key.getId()), (Throwable)ex);
                    }
                    finally {
                        RequestLifeCycle.end();
                    }
                };
                futures.add(this.executor.submit(task));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while migrate user pages", (Throwable)ex);
        }
        finally {
            LOG.info((Object)("DONE remove navigations/pages for " + size + " user sites"));
        }
    }

    private void removeNavs(NavigationContext context) {
        NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, context, Scope.ALL, null);
        this.removeNavNode(node);
        this.navigationService.saveNavigation(context);
    }

    private void removeNavNode(NodeContext node) {
        LOG.info((Object)("Try to remove node: " + node.getName()));
        if (node.getNodeSize() > 0) {
            LOG.info((Object)("Remove children of " + node.getName()));
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                this.removeNavNode((NodeContext)iterator.next());
            }
            LOG.info((Object)("Done remove children of " + node.getName()));
            this.navigationService.saveNode(node, null);
        }
        if (node.getParent() != null) {
            PageKey pageKey = node.getState().getPageRef();
            if (pageKey != null) {
                LOG.info((Object)("Try to remove page " + pageKey.format() + " reference from navigation " + node.getName()));
                this.pageService.destroyPage(pageKey);
            }
            LOG.info((Object)("Remove navigation node " + node.getName()));
            node.removeNode();
        }
    }
}

