/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobSchedulerService;

public class ResumeDigestJobUpgradePlugin
extends UpgradeProductPlugin {
    private JobSchedulerService schedulerService;
    private static final Log LOG = ExoLogger.getLogger(ResumeDigestJobUpgradePlugin.class);

    public ResumeDigestJobUpgradePlugin(JobSchedulerService schedulerService, InitParams initParams) {
        super(initParams);
        this.schedulerService = schedulerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            this.schedulerService.resumeJob("NotificationDailyJob", "Notification");
            this.schedulerService.resumeJob("NotificationWeeklyJob", "Notification");
        }
        catch (Exception e) {
            LOG.error((Object)"Error when resuming daily and weekly job", (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

