/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.upgrade.plugins.AbstractGadgetToPortletPlugin;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeGadgetToPortletPlugin
extends AbstractGadgetToPortletPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeGadgetToPortletPlugin.class);

    public UpgradeGadgetToPortletPlugin(SettingService settingService, ModelDataStorage modelDataStorage, PageService pageService, NavigationService navigationService, RepositoryService repoService, InitParams initParams) {
        super(settingService, modelDataStorage, pageService, navigationService, repoService, initParams);
    }

    public UpgradeGadgetToPortletPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Remove the Monitoring and Management pages");
        this.removeNavs();
        LOG.info((Object)"Migrate Gadgets on portal pages");
        this.migratePages(SiteType.PORTAL);
        LOG.info((Object)"Migrate Gadgets on group pages");
        this.migratePages(SiteType.GROUP);
        LOG.info((Object)"Migrate Gadgets on portal site layout");
        this.migratePortals(SiteType.PORTAL);
        LOG.info((Object)"Migrate Gadgets on group sites layout");
        this.migratePortals(SiteType.GROUP);
        LOG.info((Object)"Migrate gadgets done");
    }

    private void removeNavs() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            NavigationContext navigation = this.navigationService.loadNavigation(SiteKey.group((String)"/platform/administrators"));
            NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
            this.removeNavNode(node, "monitoring");
            this.removeNavNode(node, "servicesManagement");
            this.navigationService.saveNode(node, null);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void removeNavNode(NodeContext root, String name) {
        NodeContext node = root.get(name);
        NodeState state = node.getState();
        PageKey pageKey = state.getPageRef();
        LOG.info((Object)("Remove page: " + name));
        this.pageService.destroyPage(pageKey);
        LOG.info((Object)("Remove navigation node: " + name));
        node.removeNode();
    }
}

