/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.jcr;

import org.exoplatform.application.gadget.Gadget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataMapper {
    static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    static final String PRIMARY_TYPE = "jcr:primaryType";
    static final String EXO_DATA_TYPE = "exo:dataType";
    static final String EXO_GADGET_NAME = "exo:gadgetName";
    static final String EXO_GADGET_URL = "exo:gadgetUrl";
    static final String EXO_GADGET_TITLE = "exo:gadgetTitle";
    static final String EXO_GADGET_DESCRIPTION = "exo:gadgetDescription";
    static final String EXO_GADGET_REF_URL = "exo:gadgetRefUrl";
    static final String EXO_GADGET_THUMB = "exo:gadgetThumb";
    static final String EXO_GADGET_IS_REMOTE = "exo:gadgetIsRemote";

    public void map(Document doc, Gadget app) throws Exception {
        Element root = doc.getDocumentElement();
        this.prepareXmlNamespace(root);
        root.setAttribute(PRIMARY_TYPE, EXO_REGISTRYENTRY_NT);
        root.setAttribute(EXO_DATA_TYPE, app.getClass().getSimpleName());
        root.setAttribute(EXO_GADGET_NAME, app.getName());
        root.setAttribute(EXO_GADGET_URL, app.getUrl());
        root.setAttribute(EXO_GADGET_TITLE, app.getTitle());
        root.setAttribute(EXO_GADGET_DESCRIPTION, app.getDescription());
        root.setAttribute(EXO_GADGET_REF_URL, app.getReferenceUrl());
        root.setAttribute(EXO_GADGET_THUMB, app.getThumbnail());
        root.setAttribute(EXO_GADGET_IS_REMOTE, String.valueOf(app.isLocal()));
    }

    public Gadget toApplciation(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        Gadget app = new Gadget();
        app.setName(root.getAttribute(EXO_GADGET_NAME));
        app.setUrl(root.getAttribute(EXO_GADGET_URL));
        app.setTitle(root.getAttribute(EXO_GADGET_TITLE));
        app.setDescription(root.getAttribute(EXO_GADGET_DESCRIPTION));
        app.setReferenceUrl(root.getAttribute(EXO_GADGET_REF_URL));
        app.setThumbnail(root.getAttribute(EXO_GADGET_THUMB));
        app.setLocal(Boolean.valueOf(root.getAttribute(EXO_GADGET_IS_REMOTE)));
        return app;
    }

    private void prepareXmlNamespace(Element element) {
        this.setXmlNameSpace(element, "xmlns:exo", "http://www.exoplatform.com/jcr/exo/1.0");
        this.setXmlNameSpace(element, "xmlns:jcr", "http://www.jcp.org/jcr/1.0");
    }

    private void setXmlNameSpace(Element element, String key, String value) {
        String xmlns = element.getAttribute(key);
        if (xmlns == null || xmlns.trim().length() < 1) {
            element.setAttribute(key, value);
        }
    }
}

