/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.jcr.DataMapper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetRegistryServiceImpl
implements GadgetRegistryService {
    private static final String PATH = "exo:services/Gadgets";
    private static final String DEFAULT_DEVELOPER_GROUP = "/platform/administrators";
    private RegistryService regService_;
    private DataMapper mapper_ = new DataMapper();
    private OrganizationService orgService;
    private String gadgetDeveloperGroup = null;

    public GadgetRegistryServiceImpl(InitParams params, RegistryService service) throws Exception {
        PropertiesParam properties;
        this.regService_ = service;
        if (params != null && (properties = params.getPropertiesParam("developerInfo")) != null) {
            this.gadgetDeveloperGroup = properties.getProperty("developer.group");
        }
        if (this.gadgetDeveloperGroup == null) {
            this.gadgetDeveloperGroup = DEFAULT_DEVELOPER_GROUP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gadget getGadget(String name) throws Exception {
        RegistryEntry entry;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            entry = this.regService_.getEntry(sessionProvider, "exo:services/Gadgets/" + name);
        }
        catch (PathNotFoundException pnfe) {
            Gadget gadget = null;
            return gadget;
        }
        finally {
            sessionProvider.close();
        }
        Gadget gadget = this.mapper_.toApplciation(entry.getDocument());
        return gadget;
    }

    @Override
    public List<Gadget> getAllGadgets() throws Exception {
        return this.getAllGadgets(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Gadget> getAllGadgets(Comparator<Gadget> sortComparator) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node regNode = this.regService_.getRegistry(sessionProvider).getNode();
            if (!regNode.hasNode(PATH)) {
                ArrayList<Gadget> arrayList = new ArrayList<Gadget>();
                return arrayList;
            }
            NodeIterator itr = regNode.getNode(PATH).getNodes();
            ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
            while (itr.hasNext()) {
                String entryPath = itr.nextNode().getPath().substring(regNode.getPath().length() + 1);
                RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
                Gadget gadget = this.mapper_.toApplciation(entry.getDocument());
                gadgets.add(gadget);
            }
            if (sortComparator != null) {
                Collections.sort(gadgets, sortComparator);
            }
            ArrayList<Gadget> arrayList = gadgets;
            return arrayList;
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveGadget(Gadget gadget) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, "exo:services/Gadgets/" + gadget.getName());
            this.mapper_.map(entry.getDocument(), gadget);
            this.regService_.recreateEntry(sessionProvider, PATH, entry);
        }
        catch (PathNotFoundException pnfe) {
            RegistryEntry entry = new RegistryEntry(gadget.getName());
            this.mapper_.map(entry.getDocument(), gadget);
            this.regService_.createEntry(sessionProvider, PATH, entry);
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGadget(String name) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.regService_.removeEntry(sessionProvider, "exo:services/Gadgets/" + name);
        }
        finally {
            sessionProvider.close();
        }
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    @Override
    public boolean isGadgetDeveloper(String username) {
        try {
            OrganizationService orgService = this.getOrgService();
            MembershipHandler memberShipHandler = orgService.getMembershipHandler();
            Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(username, this.gadgetDeveloperGroup);
            if (memberships.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

