/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.exoplatform.commons.serialization.model.TypeModel;

public final class FieldModel<O, V> {
    private final TypeModel<O> owner;
    private final Field field;
    private final TypeModel<V> type;
    private boolean _transient;

    FieldModel(TypeModel<O> owner, Field field, TypeModel<V> type) {
        this.owner = owner;
        this.field = field;
        this.type = type;
        this._transient = Modifier.isTransient(field.getModifiers());
    }

    public TypeModel<O> getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isTransient() {
        return this._transient;
    }

    public TypeModel<V> getType() {
        return this.type;
    }

    public V get(Object o) {
        try {
            Object value = this.field.get(o);
            if (value == null) {
                return null;
            }
            Class<V> valueType = this.type.getJavaType();
            if (valueType.isInstance(value)) {
                return valueType.cast(value);
            }
            throw new ClassCastException("Cannot cast value " + value + " with type " + value.getClass().getName() + " to type " + valueType.getName());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void castAndSet(Object o, Object value) {
        V v = this.type.getJavaType().cast(value);
        this.set(o, v);
    }

    public void set(Object o, V value) {
        try {
            this.field.set(o, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return "FieldModel[name=" + this.field.getName() + ",owner=" + this.owner + "]";
    }
}

