/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.resolver.ClasspathResourceResolver;
import org.exoplatform.resolver.FileResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApplicationResourceResolver
extends ResourceResolver {
    protected static Log log = ExoLogger.getLogger((String)"portal:ApplicationResourceResolver");
    private Map<String, ResourceResolver> resolvers_ = new HashMap<String, ResourceResolver>();

    public ApplicationResourceResolver() {
        this.addResourceResolver(new FileResourceResolver());
        this.addResourceResolver(new ClasspathResourceResolver());
    }

    public ResourceResolver getResourceResolverByScheme(String scheme) {
        return this.resolvers_.get(scheme);
    }

    public ResourceResolver getResourceResolver(String url) {
        String scheme = "app:";
        int index = url.indexOf(":");
        if (index > 0) {
            scheme = url.substring(0, index + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to extract resource resolver for the url: " + url));
        }
        return this.resolvers_.get(scheme);
    }

    public void addResourceResolver(ResourceResolver resolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add a resource resolver for the scheme: " + resolver.getResourceScheme()));
        }
        this.resolvers_.put(resolver.getResourceScheme(), resolver);
    }

    @Override
    public URL getResource(String url) throws Exception {
        return this.getResourceResolver(url).getResource(url);
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        return this.getResourceResolver(url).getInputStream(url);
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        return this.getResourceResolver(url).getResources(url);
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        return this.getResourceResolver(url).getInputStreams(url);
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        return this.getResourceResolver(url).isModified(url, lastAccess);
    }

    @Override
    public boolean isResolvable(String url) {
        return this.getResourceResolver(url) != null;
    }

    public String getResourceIdPrefix() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public String createResourceId(String url) {
        return this.hashCode() + ":" + url;
    }

    @Override
    public String getResourceScheme() {
        return "app:";
    }
}

