/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.exoplatform.commons.utils.BinaryOutput;

public abstract class Text {
    public static Text create(byte[] bytes, Charset charset) throws IllegalArgumentException {
        return new Bytes(bytes, charset);
    }

    public static Text create(char[] chars) throws IllegalArgumentException {
        return new Chars(chars);
    }

    public static Text create(String s) throws IllegalArgumentException {
        return new Chars(s.toCharArray());
    }

    public abstract void writeTo(Writer var1) throws IOException;

    private static class Chars
    extends Text {
        private int offset;
        private int count;
        private char[] chars;

        private Chars(char[] chars) {
            this.chars = chars;
            this.offset = 0;
            this.count = chars.length;
        }

        private Chars(char[] chars, int offset, int count) {
            this.chars = chars;
            this.offset = offset;
            this.count = count;
        }

        public void writeTo(Writer writer) throws IOException {
            writer.write(this.chars, this.offset, this.count);
        }

        public String toString() {
            return new String(this.chars, this.offset, this.count);
        }
    }

    private static class Bytes
    extends Text {
        private final byte[] bytes;
        private final Charset charset;
        private volatile String s;

        private Bytes(byte[] bytes, Charset charset) {
            this.bytes = bytes;
            this.charset = charset;
        }

        public void writeTo(Writer writer) throws IOException {
            BinaryOutput osw;
            if (writer instanceof BinaryOutput && this.charset.equals((osw = (BinaryOutput)((Object)writer)).getCharset())) {
                osw.write(this.bytes);
                return;
            }
            if (this.s == null) {
                this.s = new String(this.bytes, this.charset.name());
            }
            writer.append(this.s);
        }
    }
}

