/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queues {
    private static final Queue<Object> EMPTY = new AbstractQueue<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean offer(Object o) {
            return false;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }
    };

    public static <E> Queue<E> empty() {
        Queue<Object> queue = EMPTY;
        return queue;
    }

    public static <E> Queue<E> lifo() {
        return Queues.lifo(10);
    }

    public static <E> Queue<E> lifo(int initialCapacity) {
        return new LIFO(initialCapacity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LIFO<E>
    extends AbstractQueue<E> {
        private Object[] elements;
        private int size;

        public LIFO(int initialCapacity) {
            this.elements = new Object[initialCapacity];
            this.size = 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                int count;
                {
                    this.count = LIFO.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.count > 0;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object element = LIFO.this.elements[--this.count];
                    return element;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean offer(E e) {
            int length = this.elements.length;
            if (this.size == length) {
                Object[] tmp = new Object[length * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, tmp, 0, length);
                this.elements = tmp;
            }
            this.elements[this.size++] = e;
            return true;
        }

        @Override
        public E poll() {
            if (this.size > 0) {
                int index = --this.size;
                Object element = this.elements[index];
                this.elements[index] = null;
                return (E)element;
            }
            return null;
        }

        @Override
        public E peek() {
            if (this.size > 0) {
                Object element = this.elements[this.size - 1];
                return (E)element;
            }
            return null;
        }
    }
}

