/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.dashboard.webui.component.DashboardParent;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.dashboard.webui.component.UIDashboardSelectContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.layout.PortalLayoutService;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/dashboard/webui/component/UIDashboardContainer.gtmpl", initParams={@ParamConfig(name="ContainerConfigs", value="classpath:conf/uiconf/dashboard/webui/container/ContainerConfig.groovy")})
public class UIDashboardContainer
extends org.exoplatform.webui.core.UIContainer {
    public static final int MAX_COLUMN = 4;
    public static final String COLUMN_CONTAINER = "column";
    public static final String ROW_CONTAINER = "row";
    public static final String ROOT_CONTAINER = "dashboard";
    private List<SelectItemOption<String>> containerOptions;
    private String windowId;
    private String containerTemplate = null;
    public static final String COLINDEX = "colIndex";
    public static final String ROWINDEX = "rowIndex";

    public UIDashboardContainer(InitParams initParams) throws Exception {
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.windowId = ((PortletRequestContext)context).getRequest().getWindowID();
        Param param = initParams.getParam("ContainerConfigs");
        this.containerOptions = (List)param.getMapGroovyObject(context);
        if (this.containerOptions == null) {
            return;
        }
        this.addChild(UIContainer.class, null, null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.initData();
        PortalLayoutService service = (PortalLayoutService)this.getApplicationComponent(PortalLayoutService.class);
        DashboardParent parent = (DashboardParent)this.getParent().getParent();
        Container container = service.getContainer("dashboard-" + this.windowId, parent.getDashboardOwner());
        UIContainer uiRoot = (UIContainer)this.getChild(UIContainer.class);
        this.toUIContainer(uiRoot, container);
        JavascriptManager jsmanager = context.getJavascriptManager();
        jsmanager.addCustomizedOnLoadScript((CharSequence)("eXo.webui.UIDashboard.onLoad('" + this.windowId + "'," + parent.canEdit() + ");"));
        super.processRender(context);
    }

    public void addUIGadget(UIGadget gadget, int col, int row) {
        UIContainer uiContainer = this.getColumn(col);
        List children = uiContainer.getChildren();
        if (uiContainer == null || row < 0 || row > children.size()) {
            return;
        }
        gadget.setParent((UIComponent)uiContainer);
        children.add(row, gadget);
    }

    public UIGadget getUIGadget(int col, int row) {
        UIContainer uiContainer = this.getColumn(col);
        if (uiContainer == null || row < 0 || row >= uiContainer.getChildren().size()) {
            return null;
        }
        return (UIGadget)uiContainer.getChild(row);
    }

    public UIGadget getUIGadget(String gadgetId) {
        List<UIContainer> columns = this.getColumns();
        for (int iCol = 0; iCol < this.getColumns().size(); ++iCol) {
            for (int iRow = 0; iRow < columns.get(iCol).getChildren().size(); ++iRow) {
                UIGadget gadget = (UIGadget)columns.get(iCol).getChild(iRow);
                if (!gadgetId.equals(gadget.getApplicationInstanceUniqueId())) continue;
                return gadget;
            }
        }
        return null;
    }

    public UIGadget removeUIGadget(String gadgetId) {
        UIGadget gadget = this.getUIGadget(gadgetId);
        if (gadget != null) {
            UIContainer uiContainer = (UIContainer)gadget.getParent();
            gadget.setParent(null);
            uiContainer.getChildren().remove(gadget);
        }
        return gadget;
    }

    public UIGadget removeUIGadget(int col, int row) {
        UIGadget gadget = this.getUIGadget(col, row);
        if (gadget != null) {
            this.removeUIGadget(gadget.getId());
        }
        return gadget;
    }

    public void moveUIGadget(String gadgetId, int col, int row) {
        UIGadget gadget = this.removeUIGadget(gadgetId);
        if (gadget == null) {
            return;
        }
        this.addUIGadget(gadget, col, row);
    }

    public UIContainer getColumn(int col) {
        if (col < 0 || col > this.getColumns().size()) {
            return null;
        }
        return this.getColumns().get(col);
    }

    public boolean hasUIGadget() {
        boolean flag = false;
        UIGadget gadget = (UIGadget)this.findFirstComponentOfType(UIGadget.class);
        if (gadget != null) {
            flag = true;
        }
        return flag;
    }

    public UIDashboardContainer setColumns(int num) throws Exception {
        if (num < 1 || num > 4) {
            return null;
        }
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        List<UIContainer> columns = this.getColumns();
        int colSize = columns.size();
        if (num < colSize) {
            for (int i = num; i < colSize; ++i) {
                UIContainer tempCol = columns.get(i);
                ArrayList<UIComponent> components = new ArrayList<UIComponent>();
                for (UIComponent component : tempCol.getChildren()) {
                    columns.get(num - 1).addChild(component);
                    components.add(component);
                }
                uiRoot.removeChildById(tempCol.getId());
                for (UIComponent component : components) {
                    component.setParent((UIComponent)columns.get(num - 1));
                }
            }
        } else if (num > colSize) {
            do {
                UIContainer uiContainer = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
                PortalDataMapper.toUIContainer((UIContainer)uiContainer, (Container)this.createContainer(ROW_CONTAINER, "UIColumn-" + colSize));
                uiRoot.addChild((UIComponent)uiContainer);
            } while (num > ++colSize);
        }
        return this;
    }

    public List<UIContainer> getColumns() {
        ArrayList<UIContainer> list = new ArrayList<UIContainer>();
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        uiRoot.findComponentOfType(list, UIContainer.class);
        if (list.size() > 0 && list.contains(uiRoot)) {
            list.remove(uiRoot);
        }
        return list;
    }

    public Container createContainer(String type, String id) throws Exception {
        for (SelectItemOption<String> item : this.containerOptions) {
            if (!item.getLabel().equals(type)) continue;
            Container container = this.toContainer((String)item.getValue());
            container.setId(id);
            return container;
        }
        return null;
    }

    private Container toContainer(String xml) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Container)uctx.unmarshalDocument((InputStream)is, null);
    }

    public void setContainerTemplate(String template) {
        this.containerTemplate = template;
    }

    public String getContainerTemplate() {
        return this.containerTemplate;
    }

    private void initData() throws Exception {
        PortalLayoutService service = (PortalLayoutService)this.getApplicationComponent(PortalLayoutService.class);
        DashboardParent parent = (DashboardParent)this.getParent().getParent();
        String id = "dashboard-" + this.windowId;
        if (service.getContainer(id, parent.getDashboardOwner()) != null) {
            return;
        }
        if (this.containerTemplate == null) {
            this.containerTemplate = "three-columns";
        }
        service.create(id, this.containerTemplate, parent.getDashboardOwner());
    }

    public void save() throws Exception {
        UIContainer uiRoot = (UIContainer)this.findFirstComponentOfType(UIContainer.class);
        if (!((UIDashboard)this.getParent()).canEdit()) {
            return;
        }
        PortalLayoutService service = (PortalLayoutService)this.getApplicationComponent(PortalLayoutService.class);
        DashboardParent parent = (DashboardParent)this.getParent().getParent();
        service.save(PortalDataMapper.toContainer((UIContainer)uiRoot), parent.getDashboardOwner());
    }

    private void toUIContainer(UIContainer uiContainer, Container model) throws Exception {
        uiContainer.setId(model.getId());
        uiContainer.setWidth(model.getWidth());
        uiContainer.setHeight(model.getHeight());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        ArrayList children = model.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Object child = children.get(i);
            Object uiComp = this.buildChild((UIPortalComponent)uiContainer, child);
            if (uiComp == null) continue;
            UIComponent comp = uiContainer.getChild(i);
            if (comp == null) {
                uiContainer.addChild(uiComp);
                continue;
            }
            if (comp instanceof UIContainer && uiComp instanceof UIContainer) {
                ((UIContainer)comp).setChildren(((UIContainer)uiComp).getChildren());
                continue;
            }
            uiContainer.getChildren().set(i, uiComp);
        }
        while (uiContainer.getChild(children.size()) != null) {
            String id = uiContainer.getChild(children.size()).getId();
            uiContainer.removeChildById(id);
        }
    }

    private <T extends UIComponent> T buildChild(UIPortalComponent uiParent, Object model) throws Exception {
        UIGadget uiComponent = null;
        PortalRequestContext context = Util.getPortalRequestContext();
        if (model instanceof org.exoplatform.portal.config.model.Application) {
            org.exoplatform.portal.config.model.Application application = (org.exoplatform.portal.config.model.Application)model;
            String factoryId = application.getApplicationType();
            if (factoryId.equals("eXoGadget")) {
                UIGadget uiGadget = (UIGadget)uiParent.createUIComponent((WebuiRequestContext)context, UIGadget.class, null, null);
                PortalDataMapper.toUIGadget((UIGadget)uiGadget, (org.exoplatform.portal.config.model.Application)application);
                uiComponent = uiGadget;
            }
        } else if (model instanceof Container) {
            Container container = (Container)model;
            UIContainer uiContainer = (UIContainer)uiParent.createUIComponent((WebuiRequestContext)context, UIContainer.class, container.getFactoryId(), null);
            uiContainer.setChildren(new CopyOnWriteArrayList());
            PortalDataMapper.toUIContainer((UIContainer)uiContainer, (Container)((Container)model));
            uiComponent = uiContainer;
        }
        return (T)uiComponent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetShowSelectFormActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public final void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            UIDashboard uiDashboard = (UIDashboard)((Object)event.getSource());
            if (!uiDashboard.canEdit()) {
                return;
            }
            UIDashboardSelectContainer uiSelectContainer = (UIDashboardSelectContainer)uiDashboard.getChild(UIDashboardSelectContainer.class);
            PortletRequestContext pcontext = (PortletRequestContext)event.getRequestContext();
            boolean isShow = Boolean.parseBoolean(pcontext.getRequestParameter("isShow"));
            uiSelectContainer.setShow(isShow);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGadgetActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public final void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            org.exoplatform.webui.core.UIContainer uiDashboard = (org.exoplatform.webui.core.UIContainer)event.getSource();
            if (!((UIDashboard)uiDashboard).canEdit()) {
                return;
            }
            String objectId = context.getRequestParameter("objectId");
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            uiDashboardContainer.removeUIGadget(objectId);
            uiDashboardContainer.save();
            context.addUIComponentToUpdateByAjax((UIComponent)uiDashboardContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoveGadgetActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public final void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            org.exoplatform.webui.core.UIContainer uiDashboard = (org.exoplatform.webui.core.UIContainer)event.getSource();
            if (!((UIDashboard)uiDashboard).canEdit()) {
                return;
            }
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            int col = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.COLINDEX));
            int row = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.ROWINDEX));
            String objectId = context.getRequestParameter("objectId");
            uiDashboardContainer.moveUIGadget(objectId, col, row);
            uiDashboardContainer.save();
            context.addUIComponentToUpdateByAjax((UIComponent)uiDashboardContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewGadgetActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public final void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            org.exoplatform.webui.core.UIContainer uiDashboard = (org.exoplatform.webui.core.UIContainer)event.getSource();
            if (!((UIDashboard)uiDashboard).canEdit()) {
                return;
            }
            int col = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.COLINDEX));
            int row = Integer.parseInt(context.getRequestParameter(UIDashboardContainer.ROWINDEX));
            String objectId = context.getRequestParameter("objectId");
            ApplicationRegistryService service = (ApplicationRegistryService)uiDashboard.getApplicationComponent(ApplicationRegistryService.class);
            Application application = service.getApplication(objectId);
            if (application == null) {
                return;
            }
            StringBuilder windowId = new StringBuilder("user");
            windowId.append("#").append(context.getRemoteUser());
            windowId.append(":/").append(application.getApplicationGroup() + "/" + application.getApplicationName()).append('/');
            UIGadget uiGadget = (UIGadget)((org.exoplatform.webui.core.UIContainer)event.getSource()).createUIComponent(context, UIGadget.class, null, null);
            uiGadget.setId(Integer.toString(uiGadget.hashCode() + 1));
            windowId.append(uiGadget.hashCode());
            uiGadget.setApplicationInstanceId(windowId.toString());
            UIDashboardContainer uiDashboardContainer = (UIDashboardContainer)uiDashboard.getChild(UIDashboardContainer.class);
            uiDashboardContainer.addUIGadget(uiGadget, col, row);
            uiDashboardContainer.save();
            context.addUIComponentToUpdateByAjax((UIComponent)uiDashboardContainer);
        }
    }
}

