/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.test.jcr-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestOrganization
extends AbstractKernelTest {
    private OrganizationService organizationService;

    protected void setUp() throws Exception {
        super.setUp();
        this.begin();
        PortalContainer container = this.getContainer();
        this.organizationService = (OrganizationService)container.getComponentInstance(OrganizationService.class);
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testFindGroups() throws Exception {
        GroupHandler handler = this.organizationService.getGroupHandler();
        Collection allGroups = handler.findGroups(null);
        Assert.assertTrue((allGroups.size() > 0 ? 1 : 0) != 0);
    }

    public void testFindGroupById() throws Exception {
        GroupHandler uHandler = this.organizationService.getGroupHandler();
        Collection group = uHandler.findGroupsOfUser("root");
    }

    public void testFindUserByGroup() throws Exception {
        UserHandler uHandler = this.organizationService.getUserHandler();
        PageList users = uHandler.findUsersByGroup("/platform/administrators");
        Assert.assertTrue((users.getAvailable() > 0 ? 1 : 0) != 0);
        List iterator = users.getAll();
        for (Object test : iterator) {
            User a = (User)test;
            System.out.println(a.getUserName());
        }
    }

    public void testChangePassword() throws Exception {
        UserHandler uHandler = this.organizationService.getUserHandler();
        User user = uHandler.findUserByName("root");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)uHandler.authenticate("root", "gtn"));
        user.setPassword("newPassword");
        uHandler.saveUser(user, false);
        user = uHandler.findUserByName("root");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)uHandler.authenticate("root", "newPassword"));
        user.setPassword("gtn");
        uHandler.saveUser(user, false);
    }
}

