/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.ListenerStack;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.IDMMembershipListAccess;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.gatein.common.logging.LogLevel;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;

public class MembershipDAOImpl
extends AbstractDAOImpl
implements MembershipHandler {
    private List listeners_ = new ListenerStack(5);

    public MembershipDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public final Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership m, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createMembership", new Object[]{"membership", m, "broadcast", broadcast});
        }
        if (broadcast) {
            this.preSave(m, true);
        }
        this.saveMembership(m, false);
        if (broadcast) {
            this.postSave(m, true);
        }
    }

    public void linkMembership(User user, Group g, MembershipType mt, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "linkMembership", new Object[]{"user", user, "group", g, "membershipType", mt, "broadcast", broadcast});
        }
        this.orgService.flush();
        if (g == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
        }
        if (mt == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
        }
        if (this.orgService.getMembershipTypeHandler().findMembershipType(mt.getName()) == null) {
            throw new InvalidNameException("MembershipType doesn't exist: " + mt.getName());
        }
        String plGroupName = this.getPLIDMGroupName(g.getGroupName());
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.orgService.getConfiguration().getGroupType(g.getParentId()));
        if (this.isCreateMembership(mt.getName())) {
            if (this.getIdentitySession().getRoleManager().getRoleType(mt.getName()) == null) {
                this.getIdentitySession().getRoleManager().createRoleType(mt.getName());
            }
            if (this.getIdentitySession().getRoleManager().hasRole(user.getUserName(), groupId, mt.getName())) {
                return;
            }
        }
        if (this.isAssociationMapped() && this.getAssociationMapping().equals(mt.getName())) {
            this.getIdentitySession().getRelationshipManager().associateUserByKeys(groupId, user.getUserName());
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setMembershipType(mt.getName());
        membership.setUserName(user.getUserName());
        membership.setGroupId(g.getId());
        if (broadcast) {
            this.preSave(membership, true);
        }
        this.getIdentitySession().getRoleManager().createRole(mt.getName(), user.getUserName(), groupId);
        if (broadcast) {
            this.postSave(membership, true);
        }
    }

    public void saveMembership(Membership m, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "saveMembership", new Object[]{"membership", m, "broadcast", broadcast});
        }
        this.orgService.flush();
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(m.getGroupId()));
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(m.getGroupId()));
        boolean hasRole = false;
        try {
            hasRole = this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType());
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (hasRole) {
            return;
        }
        if (broadcast) {
            this.preSave(m, false);
        }
        if (this.isCreateMembership(m.getMembershipType())) {
            try {
                this.getIdentitySession().getRoleManager().createRole(m.getMembershipType(), m.getUserName(), groupId);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        if (this.isAssociationMapped() && this.getAssociationMapping().equals(m.getMembershipType())) {
            try {
                this.getIdentitySession().getRelationshipManager().associateUserByKeys(groupId, m.getUserName());
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        if (broadcast) {
            this.postSave(m, false);
        }
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "removeMembership", new Object[]{"id", id, "broadcast", broadcast});
        }
        this.orgService.flush();
        MembershipImpl m = new MembershipImpl(id);
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(m.getGroupId()));
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(m.getGroupId()));
        boolean hasRole = false;
        try {
            hasRole = this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType());
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        boolean associated = false;
        try {
            associated = this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(groupId, m.getUserName());
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (!(hasRole || this.isAssociationMapped() && this.getAssociationMapping().equals(m.getMembershipType()) && associated)) {
            return m;
        }
        if (broadcast) {
            this.preDelete(m);
        }
        if (this.isCreateMembership(m.getMembershipType())) {
            try {
                this.getIdentitySession().getRoleManager().removeRole(m.getMembershipType(), m.getUserName(), groupId);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        if (this.isAssociationMapped() && this.getAssociationMapping().equals(m.getMembershipType()) && associated) {
            HashSet<String> keys = new HashSet<String>();
            keys.add(m.getUserName());
            try {
                this.getIdentitySession().getRelationshipManager().disassociateUsersByKeys(groupId, keys);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        if (broadcast) {
            this.postDelete(m);
        }
        return m;
    }

    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "removeMembershipByUser", new Object[]{"userName", userName, "broadcast", broadcast});
        }
        this.orgService.flush();
        Collection roles = new HashSet();
        try {
            roles = this.getIdentitySession().getRoleManager().findRoles(userName, null);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        for (Role role : roles) {
            MembershipImpl m = new MembershipImpl();
            Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).convertGroup(role.getGroup());
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            m.setMembershipType(role.getRoleType().getName());
            memberships.add(m);
            if (broadcast) {
                this.preDelete(m);
            }
            this.getIdentitySession().getRoleManager().removeRole(role);
            if (!broadcast) continue;
            this.postDelete(m);
        }
        if (this.isAssociationMapped()) {
            Collection groups = new HashSet();
            try {
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
            HashSet<String> keys = new HashSet<String>();
            keys.add(userName);
            for (org.picketlink.idm.api.Group group : groups) {
                try {
                    this.getIdentitySession().getRelationshipManager().disassociateUsersByKeys(group.getKey(), keys);
                }
                catch (Exception e) {
                    this.handleException("Identity operation error: ", e);
                }
            }
        }
        return new LinkedList(memberships);
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipByUserAndType", new Object[]{"userName", userName, "groupId", groupId, "type", type});
        }
        this.orgService.flush();
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(groupId));
        String gid = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(groupId));
        boolean hasMembership = false;
        boolean associated = false;
        try {
            associated = this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(gid, userName);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.isAssociationMapped() && this.getAssociationMapping().equals(type) && associated) {
            hasMembership = true;
        }
        Role role = null;
        try {
            role = this.getIdentitySession().getRoleManager().getRole(type, userName, gid);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (!(role == null || this.isAssociationMapped() && this.getAssociationMapping().equals(role.getRoleType()) && this.ignoreMappedMembershipType())) {
            hasMembership = true;
        }
        MembershipImpl result = null;
        if (hasMembership) {
            MembershipImpl m = new MembershipImpl();
            m.setGroupId(groupId);
            m.setUserName(userName);
            m.setMembershipType(type);
            result = m;
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipByUserGroupAndType", result);
        }
        return result;
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipByUserAndGroup", new Object[]{"userName", userName, "groupId", groupId});
        }
        this.orgService.flush();
        if (userName == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipByUserAndGroup", Collections.emptyList());
            }
            return Collections.emptyList();
        }
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(groupId));
        String gid = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(groupId));
        Collection roleTypes = new HashSet();
        try {
            roleTypes = this.getIdentitySession().getRoleManager().findRoleTypes(userName, gid, null);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        for (RoleType roleType : roleTypes) {
            if (!this.isCreateMembership(roleType.getName())) continue;
            MembershipImpl m = new MembershipImpl();
            m.setGroupId(groupId);
            m.setUserName(userName);
            m.setMembershipType(roleType.getName());
            memberships.add(m);
        }
        boolean associated = false;
        try {
            associated = this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(gid, userName);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.isAssociationMapped() && associated) {
            MembershipImpl m = new MembershipImpl();
            m.setGroupId(groupId);
            m.setUserName(userName);
            m.setMembershipType(this.getAssociationMapping());
            memberships.add(m);
        }
        LinkedList result = new LinkedList(memberships);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipByUserAndGroup", result);
        }
        return result;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipsByUser", new Object[]{"userName", userName});
        }
        this.orgService.flush();
        Collection roles = new HashSet();
        try {
            roles = this.getIdentitySession().getRoleManager().findRoles(userName, null);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        for (Role role : roles) {
            if (!this.isCreateMembership(role.getRoleType().getName())) continue;
            MembershipImpl m = new MembershipImpl();
            Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).convertGroup(role.getGroup());
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            if (role.getRoleType().getName().equals("JBOSS_IDENTITY_MEMBERSHIP")) {
                m.setMembershipType(this.orgService.getConfiguration().getAssociationMembershipType());
            } else {
                m.setMembershipType(role.getRoleType().getName());
            }
            memberships.add(m);
        }
        if (this.isAssociationMapped()) {
            Collection groups = new HashSet();
            try {
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
            for (org.picketlink.idm.api.Group group : groups) {
                MembershipImpl m = new MembershipImpl();
                Group g = ((GroupDAOImpl)this.orgService.getGroupHandler()).convertGroup(group);
                m.setGroupId(g.getId());
                m.setUserName(userName);
                m.setMembershipType(this.getAssociationMapping());
                memberships.add(m);
            }
        }
        LinkedList result = new LinkedList(memberships);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipsByUser", result);
        }
        return result;
    }

    public ListAccess<Membership> findAllMembershipsByUser(User user) throws Exception {
        org.picketlink.idm.api.User gtnUser = this.service_.getIdentitySession().getPersistenceManager().findUser(user.getUserName());
        if (gtnUser == null) {
            this.log.log(LogLevel.ERROR, (Object)("Internal ERROR. Cannot obtain user: " + user.getUserName()));
            return new ListAccessImpl(Membership.class, Collections.emptyList());
        }
        return new IDMMembershipListAccess(gtnUser);
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        return this.findMembershipsByGroupId(group.getId());
    }

    public ListAccess<Membership> findAllMembershipsByGroup(Group group) throws Exception {
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(group.getId()));
        String gid = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(group.getId()));
        org.picketlink.idm.api.Group gtnGroup = this.service_.getIdentitySession().getPersistenceManager().findGroupByKey(gid);
        if (gtnGroup == null) {
            this.log.log(LogLevel.ERROR, (Object)("Internal ERROR. Cannot obtain group: " + group.getId()));
            return new ListAccessImpl(Membership.class, Collections.emptyList());
        }
        return new IDMMembershipListAccess(gtnGroup);
    }

    public Collection findMembershipsByGroupId(String groupId) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembershipsByGroup", new Object[]{"groupId", groupId});
        }
        this.orgService.flush();
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(groupId));
        String gid = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(groupId));
        Collection roles = new HashSet();
        try {
            roles = this.getIdentitySession().getRoleManager().findRoles(gid, null);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        Group g = this.orgService.getGroupHandler().findGroupById(groupId);
        for (Role role : roles) {
            if (!this.isCreateMembership(role.getRoleType().getName())) continue;
            MembershipImpl m = new MembershipImpl();
            m.setGroupId(g.getId());
            m.setUserName(role.getUser().getId());
            m.setMembershipType(role.getRoleType().getName());
            memberships.add(m);
        }
        if (this.isAssociationMapped()) {
            Collection users = new HashSet();
            try {
                users = this.getIdentitySession().getRelationshipManager().findAssociatedUsers(gid, false, null);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
            for (org.picketlink.idm.api.User user : users) {
                MembershipImpl m = new MembershipImpl();
                m.setGroupId(groupId);
                m.setUserName(user.getId());
                m.setMembershipType(this.getAssociationMapping());
                memberships.add(m);
            }
        }
        LinkedList results = new LinkedList(memberships);
        if (this.orgService.getConfiguration().isSortMemberships()) {
            Collections.sort(results);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembershipsByGroupId", results);
        }
        return results;
    }

    public Membership findMembership(String id) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findMembership", new Object[]{"id", id});
        }
        this.orgService.flush();
        MembershipImpl m = new MembershipImpl(id);
        String plGroupName = this.getPLIDMGroupName(this.getGroupNameFromId(m.getGroupId()));
        String groupId = this.getIdentitySession().getPersistenceManager().createGroupKey(plGroupName, this.getGroupTypeFromId(m.getGroupId()));
        try {
            if (this.isCreateMembership(m.getMembershipType()) && this.getIdentitySession().getRoleManager().hasRole(m.getUserName(), groupId, m.getMembershipType())) {
                if (this.log.isTraceEnabled()) {
                    Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembership", m);
                }
                return m;
            }
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        try {
            if (this.isAssociationMapped() && this.getAssociationMapping().equals(m.getMembershipType()) && this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(groupId, m.getUserName())) {
                if (this.log.isTraceEnabled()) {
                    Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembership", m);
                }
                return m;
            }
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findMembership", null);
        }
        return null;
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            MembershipEventListener listener = (MembershipEventListener)this.listeners_.get(i);
            listener.postDelete(membership);
        }
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private String getGroupNameFromId(String groupId) {
        String[] ids = groupId.split("/");
        return ids[ids.length - 1];
    }

    private String getGroupTypeFromId(String groupId) {
        String parentId = groupId.substring(0, groupId.lastIndexOf("/"));
        return this.orgService.getConfiguration().getGroupType(parentId);
    }

    protected boolean isAssociationMapped() {
        String mapping = this.orgService.getConfiguration().getAssociationMembershipType();
        return mapping != null && mapping.length() > 0;
    }

    protected String getAssociationMapping() {
        return this.orgService.getConfiguration().getAssociationMembershipType();
    }

    protected boolean ignoreMappedMembershipType() {
        return this.orgService.getConfiguration().isIgnoreMappedMembershipType();
    }

    protected boolean isCreateMembership(String typeName) {
        return !this.isAssociationMapped() || !this.getAssociationMapping().equals(typeName) || !this.ignoreMappedMembershipType();
    }

    public String getPLIDMGroupName(String gtnGroupName) {
        return this.orgService.getConfiguration().getPLIDMGroupName(gtnGroupName);
    }

    public String getGtnGroupName(String plidmGroupName) {
        return this.orgService.getConfiguration().getGtnGroupName(plidmGroupName);
    }
}

