/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.SimpleTemplateEngine;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class TemplateService {
    private SimpleTemplateEngine engine_ = new SimpleTemplateEngine();
    private ExoCache templatesCache_;
    private boolean cacheTemplate_ = true;

    public TemplateService(InitParams params, CacheService cservice) throws Exception {
        this.templatesCache_ = cservice.getCacheInstance(TemplateService.class.getName());
        this.templatesCache_.setLiveTime(10000L);
    }

    public void merge(Template template, BindingContext context) throws Exception {
        context.put("_ctx", context);
        context.setGroovyTemplateService(this);
        Writable writable = template.make((Map)context);
        writable.writeTo(context.getWriter());
    }

    public void include(String name, BindingContext context) throws Exception {
        if (context == null) {
            throw new Exception("Binding cannot be null");
        }
        context.put("_ctx", context);
        Template template = this.getTemplate(name, context.getResourceResolver());
        Writable writable = template.make((Map)context);
        writable.writeTo(context.getWriter());
    }

    public final Template getTemplate(String name, ResourceResolver resolver) throws Exception {
        return this.getTemplate(name, resolver, this.cacheTemplate_);
    }

    public final Template getTemplate(String url, ResourceResolver resolver, boolean cacheable) throws Exception {
        Template template = null;
        if (cacheable) {
            String resourceId = resolver.createResourceId(url);
            template = (Template)this.templatesCache_.get((Serializable)((Object)resourceId));
        }
        if (template != null) {
            return template;
        }
        InputStream is = resolver.getInputStream(url);
        byte[] bytes = null;
        try {
            bytes = IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        catch (Exception exp) {
            throw new NullPointerException("Cann't load groovy template in " + url);
        }
        is.close();
        String text = new String(bytes);
        template = this.engine_.createTemplate(text);
        if (cacheable) {
            String resourceId = resolver.createResourceId(url);
            this.templatesCache_.put((Serializable)((Object)resourceId), (Object)template);
        }
        return template;
    }

    public final void invalidateTemplate(String name, ResourceResolver resolver) throws Exception {
        String resourceId = resolver.createResourceId(name);
        this.templatesCache_.remove((Serializable)((Object)resourceId));
    }
}

