/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript.text;

import org.exoplatform.commons.utils.AtomicPositiveLong;
import org.exoplatform.commons.utils.LongSampler;
import org.exoplatform.resolver.ResourceResolver;

public class TemplateStatistic {
    private final LongSampler times = new LongSampler(1000);
    private String name;
    private final AtomicPositiveLong maxTime = new AtomicPositiveLong();
    private final AtomicPositiveLong minTime = new AtomicPositiveLong();
    private volatile long countRequest = 0L;
    private ResourceResolver resolver;

    public TemplateStatistic(String name) {
        this.name = name;
    }

    public void setTime(long timeMillis) {
        this.times.add(timeMillis);
        this.maxTime.setIfGreater(timeMillis);
        this.minTime.setIfLower(timeMillis);
        ++this.countRequest;
    }

    public double getMaxTime() {
        long maxTime = this.maxTime.get();
        if (maxTime == -1L) {
            return -1.0;
        }
        return maxTime;
    }

    public double getMinTime() {
        long minTime = this.minTime.get();
        if (minTime == -1L) {
            return -1.0;
        }
        return minTime;
    }

    public double getAverageTime() {
        return this.times.average();
    }

    public long executionCount() {
        return this.countRequest;
    }

    public void setResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }
}

