/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import groovy.lang.Binding;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.exoplatform.commons.utils.OutputStreamPrinter;
import org.exoplatform.groovyscript.BaseScript;
import org.exoplatform.groovyscript.GroovyPrinter;
import org.exoplatform.groovyscript.OutputStreamWriterGroovyPrinter;
import org.exoplatform.groovyscript.TemplateRuntimeException;
import org.exoplatform.groovyscript.TextItem;
import org.exoplatform.groovyscript.WriterGroovyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScript {
    private final String templateId;
    private final String groovyText;
    private final Class<?> scriptClass;
    private final Map<Integer, TextItem> lineTable;

    public GroovyScript(String templateId, String groovyText, Class<?> scriptClass, Map<Integer, TextItem> lineTable) {
        this.templateId = templateId;
        this.groovyText = groovyText;
        this.scriptClass = scriptClass;
        this.lineTable = lineTable;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getGroovyText() {
        return this.groovyText;
    }

    public Class<?> getScriptClass() {
        return this.scriptClass;
    }

    public void render(Map context, Writer writer) throws IOException, TemplateRuntimeException {
        Binding binding = context != null ? new Binding(context) : new Binding();
        GroovyPrinter printer = writer instanceof OutputStreamPrinter ? new OutputStreamWriterGroovyPrinter((OutputStreamPrinter)writer) : new WriterGroovyPrinter(writer);
        BaseScript script = (BaseScript)InvokerHelper.createScript(this.scriptClass, (Binding)binding);
        script.printer = printer;
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw this.buildRuntimeException(e);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw this.buildRuntimeException(e);
        }
        script.flush();
    }

    private TemplateRuntimeException buildRuntimeException(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        TextItem firstItem = null;
        for (int i = 0; i < trace.length; ++i) {
            int templateLineNumber;
            StackTraceElement element = trace[i];
            if (!element.getClassName().equals(this.scriptClass.getName())) continue;
            int lineNumber = element.getLineNumber();
            TextItem item = this.lineTable.get(lineNumber);
            if (item != null) {
                templateLineNumber = item.getPosition().getLine();
                if (firstItem == null) {
                    firstItem = item;
                }
            } else {
                templateLineNumber = -1;
            }
            trace[i] = element = new StackTraceElement(element.getClassName(), element.getMethodName(), element.getFileName(), templateLineNumber);
        }
        t.setStackTrace(trace);
        return new TemplateRuntimeException(this.templateId, firstItem, t);
    }
}

