/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;

public abstract class AbstractApplicationMessage
implements Serializable {
    private static Log log = ExoLogger.getLogger(ApplicationMessage.class);
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    private int type_ = 2;
    private transient ResourceBundle resourceBundle;
    private boolean argsLocalized = true;

    public abstract String getMessage();

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    protected ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public int getType() {
        return this.type_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public void setArgsLocalized(boolean argsLocalized) {
        this.argsLocalized = argsLocalized;
    }

    public boolean isArgsLocalized() {
        return this.argsLocalized;
    }

    protected String resolveMessage(String key) {
        String value;
        if (key == null && this.resourceBundle == null) {
            return key;
        }
        try {
            value = this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (PropertyManager.isDevelopping()) {
                log.warn((Object)("Can not find resource bundle for key : " + key));
            }
            value = key.substring(key.lastIndexOf(46) + 1);
        }
        return value;
    }
}

