/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import org.exoplatform.web.controller.regexp.GroupType;
import org.exoplatform.web.controller.regexp.Quantifier;

public abstract class RENode {
    private Ref<?> owner;

    public abstract String toString();

    public final RENode getParent() {
        return this.owner != null ? ((Ref)this.owner).parent : null;
    }

    public final RENode replaceBy(RENode that) throws IllegalStateException {
        if (this.owner == null) {
            throw new IllegalStateException("Not attached");
        }
        return this.owner.replace(that);
    }

    protected static class NonNullableRef<N extends RENode>
    extends Ref<N> {
        private N node;
        final /* synthetic */ RENode this$0;

        public NonNullableRef(RENode parent, Class<N> type, N node) {
            this.this$0 = var1_1;
            super(parent, type);
            if (node == null) {
                throw new NullPointerException();
            }
            if (((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            ((RENode)node).owner = this;
            this.node = node;
        }

        @Override
        protected N set(N node) {
            if (node == null) {
                throw new NullPointerException("No null node accepted");
            }
            if (((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            N previous = this.node;
            ((RENode)this.node).owner = null;
            ((RENode)node).owner = this;
            this.node = node;
            return previous;
        }

        @Override
        protected N get() {
            return this.node;
        }
    }

    protected static class NullableRef<N extends RENode>
    extends Ref<N> {
        private N node;
        final /* synthetic */ RENode this$0;

        public NullableRef(RENode rENode, RENode parent, Class<N> type) {
            this(rENode, parent, type, null);
        }

        public NullableRef(RENode parent, Class<N> type, N node) {
            this.this$0 = var1_1;
            super(parent, type);
            if (node != null) {
                if (((RENode)node).owner != null) {
                    throw new IllegalArgumentException();
                }
                ((RENode)node).owner = this;
            }
            this.node = node;
        }

        @Override
        protected N set(N node) {
            if (node != null && ((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            N previous = this.node;
            if (this.node != null) {
                ((RENode)this.node).owner = null;
            }
            if (node != null) {
                ((RENode)node).owner = this;
                this.node = node;
            } else {
                this.node = null;
            }
            return previous;
        }

        @Override
        protected N get() {
            return this.node;
        }
    }

    protected abstract class Ref<N extends RENode> {
        private final Class<N> type;
        private final RENode parent;

        protected Ref(RENode parent, Class<N> type) {
            this.parent = parent;
            this.type = type;
        }

        public final Class<N> getType() {
            return this.type;
        }

        protected abstract N set(N var1);

        protected abstract N get();

        protected final boolean isNull() {
            return this.get() == null;
        }

        protected final boolean isNotNull() {
            return this.get() != null;
        }

        protected final N replace(RENode that) {
            if (that == null || this.type.isInstance(that)) {
                return (N)this.set((RENode)this.type.cast(that));
            }
            throw new ClassCastException("Cannot cast node with type " + that.getClass().getName() + " to type " + this.type.getName());
        }
    }

    public static abstract class CharacterClassExpr
    extends RENode {
        private CharacterClassExpr() {
        }

        public CharacterClassExpr remove(char c) {
            throw new UnsupportedOperationException();
        }

        public CharacterClassExpr replace(char src, char dst) {
            throw new UnsupportedOperationException();
        }

        public static class Range
        extends CharacterClassExpr {
            private Char from;
            private Char to;

            public Range(Char from, Char to) {
                if (from.value > to.value) {
                    throw new IllegalArgumentException("From cannot be greater or equals than to");
                }
                this.from = from;
                this.to = to;
            }

            @Override
            public CharacterClassExpr remove(char c) throws IllegalArgumentException {
                if (this.from.value == this.to.value) {
                    if (this.from.value == c) {
                        throw new UnsupportedOperationException();
                    }
                } else {
                    if (this.from.value + '\u0001' == this.to.value) {
                        if (this.from.value == c) {
                            Char repl = new Char(this.to.value);
                            this.replaceBy(repl);
                            return repl;
                        }
                        Char repl = new Char(this.from.value);
                        this.replaceBy(repl);
                        return repl;
                    }
                    if (this.from.value == c) {
                        Char.access$508(this.from);
                    } else if (this.to.value == c) {
                        Char.access$510(this.to);
                    } else if (this.from.value < c && c < this.to.value) {
                        CharacterClassExpr left = this.from.value + '\u0001' == c ? new Char(this.from.value) : new Range(this.from, new Char((char)(c - '\u0001')));
                        CharacterClassExpr right = c == this.to.value - '\u0001' ? new Char(this.to.value) : new Range(new Char((char)(c + '\u0001')), this.to);
                        Or repl = new Or(left, right);
                        this.replaceBy(repl);
                        return repl;
                    }
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                CharacterClassExpr repl = this.remove(src);
                if (repl != this) {
                    Or or = new Or(null, new Char(dst));
                    repl.replaceBy(or);
                    or.setLeft(repl);
                    repl = or;
                }
                return repl;
            }

            public Char getFrom() {
                return this.from;
            }

            public Char getTo() {
                return this.to;
            }

            @Override
            public String toString() {
                return "[" + this.from.value + "-" + this.to.value + "]";
            }
        }

        public static class Char
        extends CharacterClassExpr {
            private char value;

            public Char(char value) {
                this.value = value;
            }

            public char getValue() {
                return this.value;
            }

            public void setValue(char value) {
                this.value = value;
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (c == this.value) {
                    this.replaceBy(null);
                    return null;
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (src == this.value) {
                    this.value = dst;
                }
                return this;
            }

            @Override
            public String toString() {
                return "[" + this.value + "]";
            }

            static /* synthetic */ char access$508(Char x0) {
                char c = x0.value;
                x0.value = (char)(c + '\u0001');
                return c;
            }

            static /* synthetic */ char access$510(Char x0) {
                char c = x0.value;
                x0.value = (char)(c - '\u0001');
                return c;
            }
        }

        public static class And
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> left;
            private final Ref<CharacterClassExpr> right;

            public And(CharacterClassExpr left, CharacterClassExpr right) {
                this.left = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)left);
                this.right = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)right);
            }

            public CharacterClassExpr getLeft() {
                return this.left.get();
            }

            public void setLeft(CharacterClassExpr left) {
                this.left.set(left);
            }

            public CharacterClassExpr getRight() {
                return this.right.get();
            }

            public void setRight(CharacterClassExpr right) {
                this.right.set(right);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (this.left.isNotNull()) {
                    this.left.get().remove(c);
                }
                if (this.right.isNotNull()) {
                    this.right.get().remove(c);
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (this.left.isNotNull()) {
                    this.left.get().replace(src, dst);
                }
                if (this.right.isNotNull()) {
                    this.right.get().replace(src, dst);
                }
                return this;
            }

            @Override
            public String toString() {
                String l = this.left.isNotNull() ? this.left.get().toString() : "";
                String r = this.right.isNotNull() ? this.right.get().toString() : "";
                return "[" + l + "&&" + r + "]";
            }
        }

        public static class Or
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> left;
            private final Ref<CharacterClassExpr> right;

            public Or(CharacterClassExpr left, CharacterClassExpr right) {
                this.left = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)left);
                this.right = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)right);
            }

            public CharacterClassExpr getLeft() {
                return this.left.get();
            }

            public void setLeft(CharacterClassExpr left) {
                this.left.set(left);
            }

            public CharacterClassExpr getRight() {
                return this.right.get();
            }

            public void setRight(CharacterClassExpr right) {
                this.right.set(right);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (this.left.isNotNull()) {
                    this.left.get().remove(c);
                }
                if (this.right.isNotNull()) {
                    this.right.get().remove(c);
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (this.left.isNotNull()) {
                    this.left.get().replace(src, dst);
                }
                if (this.right.isNotNull()) {
                    this.right.get().replace(src, dst);
                }
                return this;
            }

            @Override
            public String toString() {
                String l = this.left.isNotNull() ? this.left.get().toString() : "";
                String r = this.right.isNotNull() ? this.right.get().toString() : "";
                return "[" + l + "||" + r + "]";
            }
        }

        public static class Not
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> negated;

            public Not(CharacterClassExpr negated) {
                this.negated = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)negated);
            }

            public CharacterClassExpr getNegated() {
                return this.negated.get();
            }

            public void setNegated(CharacterClassExpr negated) {
                this.negated.set(negated);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                this.negated.get().remove(c);
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                this.negated.get().replace(src, dst);
                return this;
            }

            @Override
            public String toString() {
                return "[^" + this.negated.get() + "]";
            }
        }
    }

    public static class CharacterClass
    extends Atom {
        private final Ref<CharacterClassExpr> expr;

        public CharacterClass(CharacterClassExpr expr) {
            this.expr = new NonNullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)expr);
        }

        public CharacterClassExpr getExpr() {
            return this.expr.get();
        }

        public void setExpr(CharacterClassExpr expr) {
            this.expr.set(expr);
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append(this.expr.get());
        }
    }

    public static final class Char
    extends Atom {
        private char value;

        public Char(char value) {
            this.value = value;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value) {
            this.value = value;
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<c>").append(this.value).append("</c>");
        }
    }

    public static final class Any
    extends Atom {
        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<./>");
        }
    }

    public static abstract class Atom
    extends Expr {
        private Atom() {
        }
    }

    public static final class Group
    extends Expr {
        private GroupType type;
        private final Ref<Disjunction> disjunction;

        public Group(Disjunction disjunction, GroupType type) {
            this.disjunction = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)disjunction);
            this.type = type;
        }

        public Disjunction getDisjunction() {
            return this.disjunction.get();
        }

        public void setDisjunction(Disjunction disjunction) {
            this.disjunction.set(disjunction);
        }

        public GroupType getType() {
            return this.type;
        }

        public void setType(GroupType type) {
            this.type = type;
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<").append(this.type.getOpen()).append('>').append(this.disjunction.get()).append("</").append(this.type.getOpen()).append(">");
        }
    }

    public static abstract class Assertion
    extends Expr {
        private Assertion() {
        }

        public static final class End
        extends Assertion {
            @Override
            protected void writeTo(StringBuilder sb) {
                sb.append("<$/>");
            }
        }

        public static final class Begin
        extends Assertion {
            @Override
            protected void writeTo(StringBuilder sb) {
                sb.append("<^/>");
            }
        }
    }

    public static abstract class Expr
    extends RENode {
        private Quantifier quantifier;

        private Expr() {
        }

        public final Quantifier getQuantifier() {
            return this.quantifier;
        }

        public final void setQuantifier(Quantifier quantifier) {
            this.quantifier = quantifier;
        }

        @Override
        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.quantifier != null) {
                String q = this.quantifier.toString();
                sb.append('<').append(q).append('>');
                this.writeTo(sb);
                sb.append("</").append(q).append('>');
            } else {
                this.writeTo(sb);
            }
            return sb.toString();
        }

        protected abstract void writeTo(StringBuilder var1);
    }

    public static final class Alternative
    extends RENode {
        private final Ref<Expr> exp;
        private final Ref<Alternative> next;

        public Alternative(Expr exp) {
            this(exp, null);
        }

        public Alternative(Expr exp, Alternative next) {
            this.exp = new NonNullableRef((RENode)this, (RENode)this, Expr.class, (RENode)exp);
            this.next = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)next);
        }

        public Expr getExp() {
            return this.exp.get();
        }

        public void setExp(Expr exp) {
            this.exp.set(exp);
        }

        public Alternative getNext() {
            return this.next.get();
        }

        public void setNext(Alternative next) {
            this.next.set(next);
        }

        @Override
        public String toString() {
            if (this.next.isNotNull()) {
                return this.exp.get().toString() + this.next.get();
            }
            return this.exp.get().toString();
        }
    }

    public static final class Disjunction
    extends RENode {
        private final NullableRef<Alternative> alternative;
        private final NullableRef<Disjunction> next;

        public Disjunction(Alternative alternative) {
            this(alternative, null);
        }

        public Disjunction(Alternative alternative, Disjunction next) {
            this.alternative = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)alternative);
            this.next = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)next);
        }

        public Alternative getAlternative() {
            return this.alternative.get();
        }

        public void setAlternative(Alternative alternative) {
            this.alternative.set(alternative);
        }

        public Disjunction getNext() {
            return this.next.get();
        }

        public void setNext(Disjunction next) {
            this.next.set(next);
        }

        @Override
        public String toString() {
            if (this.next.isNotNull()) {
                if (this.alternative.isNotNull()) {
                    return this.alternative.get() + "|" + this.next.get();
                }
                return this.next.get().toString();
            }
            if (this.alternative.isNotNull()) {
                return this.alternative.get().toString();
            }
            return "";
        }
    }
}

