/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import java.io.IOException;
import org.exoplatform.web.controller.regexp.Literal;
import org.exoplatform.web.controller.regexp.Quantifier;
import org.exoplatform.web.controller.regexp.RENode;

public class RERenderer {
    public final <A extends Appendable> A render(RENode re, A appendable) throws IOException, NullPointerException {
        if (re == null) {
            throw new NullPointerException("No null disjunction accepted");
        }
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        this.doRender(re, appendable);
        return appendable;
    }

    protected void doRender(RENode re, Appendable appendable) throws IOException {
        if (re instanceof RENode.Disjunction) {
            this.doRender((RENode.Disjunction)re, appendable);
        } else if (re instanceof RENode.Alternative) {
            this.doRender((RENode.Alternative)re, appendable);
        } else if (re instanceof RENode.Expr) {
            this.doRender((RENode.Expr)re, appendable);
        } else {
            throw new AssertionError((Object)("Was not expecting node " + re));
        }
    }

    protected void doRender(RENode.Disjunction disjunction, Appendable appendable) throws IOException, NullPointerException {
        RENode.Alternative alternative = disjunction.getAlternative();
        RENode.Disjunction next = disjunction.getNext();
        if (alternative != null) {
            this.doRender(alternative, appendable);
            if (next != null) {
                appendable.append('|');
                this.doRender(next, appendable);
            }
        } else if (next != null) {
            this.doRender(next, appendable);
        }
    }

    protected void doRender(RENode.Alternative alternative, Appendable appendable) throws IOException, NullPointerException {
        this.doRender(alternative.getExp(), appendable);
        RENode.Alternative next = alternative.getNext();
        if (next != null) {
            this.doRender(next, appendable);
        }
    }

    protected void doRender(RENode.Expr expr, Appendable appendable) throws IOException, NullPointerException {
        if (expr instanceof RENode.Atom) {
            this.doRender((RENode.Atom)expr, appendable);
        } else if (expr instanceof RENode.Group) {
            this.doRender((RENode.Group)expr, appendable);
        } else if (expr instanceof RENode.Assertion) {
            this.doRender((RENode.Assertion)expr, appendable);
        } else {
            throw new AssertionError((Object)("Was not expecting node " + expr));
        }
    }

    protected void doRender(Quantifier quantifier, Appendable appendable) throws IOException {
        quantifier.toString(appendable);
    }

    protected void doRender(RENode.Assertion assertion, Appendable appendable) throws IOException {
        if (assertion instanceof RENode.Assertion.Begin) {
            this.doRender((RENode.Assertion.Begin)assertion, appendable);
        } else if (assertion instanceof RENode.Assertion.End) {
            this.doRender((RENode.Assertion.End)assertion, appendable);
        } else {
            throw new AssertionError((Object)("Was not expecting node " + assertion));
        }
    }

    protected void doRender(RENode.Assertion.Begin expr, Appendable appendable) throws IOException {
        appendable.append('^');
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.Assertion.End expr, Appendable appendable) throws IOException {
        appendable.append('$');
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.Group expr, Appendable appendable) throws IOException {
        appendable.append(expr.getType().getOpen());
        this.doRender(expr.getDisjunction(), appendable);
        appendable.append(expr.getType().getClose());
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.Atom atom, Appendable appendable) throws IOException {
        if (atom instanceof RENode.Any) {
            this.doRender((RENode.Any)atom, appendable);
        } else if (atom instanceof RENode.Char) {
            this.doRender((RENode.Char)atom, appendable);
        } else if (atom instanceof RENode.CharacterClass) {
            this.doRender((RENode.CharacterClass)atom, appendable);
        } else {
            throw new AssertionError((Object)("Was not expecting node " + atom));
        }
    }

    protected void doRender(RENode.Char expr, Appendable appendable) throws IOException {
        Literal.escapeTo(expr.getValue(), appendable);
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.Any expr, Appendable appendable) throws IOException {
        appendable.append('.');
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.CharacterClass expr, Appendable appendable) throws IOException {
        appendable.append("[");
        this.doRender(expr.getExpr(), appendable);
        appendable.append("]");
        if (expr.getQuantifier() != null) {
            this.doRender(expr.getQuantifier(), appendable);
        }
    }

    protected void doRender(RENode.CharacterClassExpr expr, Appendable appendable) throws IOException, NullPointerException {
        if (expr instanceof RENode.CharacterClassExpr.Char) {
            this.doRender((RENode.CharacterClassExpr.Char)expr, appendable);
        } else if (expr instanceof RENode.CharacterClassExpr.Range) {
            this.doRender((RENode.CharacterClassExpr.Range)expr, appendable);
        } else if (expr instanceof RENode.CharacterClassExpr.And) {
            this.doRender((RENode.CharacterClassExpr.And)expr, appendable);
        } else if (expr instanceof RENode.CharacterClassExpr.Or) {
            this.doRender((RENode.CharacterClassExpr.Or)expr, appendable);
        } else if (expr instanceof RENode.CharacterClassExpr.Not) {
            this.doRender((RENode.CharacterClassExpr.Not)expr, appendable);
        } else {
            throw new AssertionError();
        }
    }

    protected void doRender(RENode.CharacterClassExpr.Not expr, Appendable appendable) throws IOException {
        boolean needBrace = false;
        for (RENode current = expr.getParent(); current != null; current = current.getParent()) {
            if (current instanceof RENode.CharacterClassExpr.Or) {
                needBrace = true;
                break;
            }
            if (current instanceof RENode.CharacterClassExpr.And) {
                needBrace = true;
                break;
            }
            if (!(current instanceof RENode.CharacterClassExpr.Not)) continue;
            needBrace = true;
            break;
        }
        if (needBrace) {
            appendable.append("[");
        }
        appendable.append("^");
        this.doRender(expr.getNegated(), appendable);
        if (needBrace) {
            appendable.append(']');
        }
    }

    protected void doRender(RENode.CharacterClassExpr.Or expr, Appendable appendable) throws IOException {
        this.doRender(expr.getLeft(), appendable);
        this.doRender(expr.getRight(), appendable);
    }

    protected void doRender(RENode.CharacterClassExpr.And expr, Appendable appendable) throws IOException {
        this.doRender(expr.getLeft(), appendable);
        appendable.append("&&");
        this.doRender(expr.getRight(), appendable);
    }

    protected void doRender(RENode.CharacterClassExpr.Range expr, Appendable appendable) throws IOException {
        this.doRender(expr.getFrom(), appendable);
        appendable.append('-');
        this.doRender(expr.getTo(), appendable);
    }

    protected void doRender(RENode.CharacterClassExpr.Char expr, Appendable appendable) throws IOException {
        Literal.escapeTo(expr.getValue(), appendable);
    }
}

