/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import javax.servlet.ServletContext;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.AbstractSkinModule;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortalSkinTask
extends AbstractSkinModule
implements SkinConfigTask {
    private static final String DEFAULT_MODULE_NAME = "CoreSkin";
    private static final String DEFAULT_SKIN_NAME = "Default";
    private String moduleName;

    public PortalSkinTask() {
        super(DEFAULT_SKIN_NAME);
        this.overwrite = true;
        this.moduleName = DEFAULT_MODULE_NAME;
    }

    private void bindingModuleName(Element element) {
        NodeList nodes = element.getElementsByTagName("skin-module");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.moduleName = nodes.item(0).getFirstChild().getNodeValue();
    }

    public void binding(Element elemt) {
        this.bindingCSSPath(elemt);
        this.bindingSkinName(elemt);
        this.bindingModuleName(elemt);
        this.bindingOverwrite(elemt);
    }

    public void execute(SkinService skinService, ServletContext scontext) {
        if (this.moduleName == null || this.skinName == null || this.cssPath == null) {
            return;
        }
        String contextPath = scontext.getContextPath();
        String fullCSSPath = contextPath + this.cssPath;
        skinService.addPortalSkin(this.moduleName, this.skinName, fullCSSPath, scontext, this.overwrite);
        this.updateSkinDependentManager(contextPath, this.moduleName, this.skinName);
    }

    private void updateSkinDependentManager(String webApp, String moduleName, String skinName) {
        SkinDependentManager.addPortalSkin(webApp, moduleName, skinName);
        SkinDependentManager.addSkinDeployedInApp(webApp, skinName);
        SkinDependentManager.addDependentAppToSkinName(skinName, webApp);
    }
}

