/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.web.application.javascript.CachedJavascript;
import org.exoplatform.web.application.javascript.Javascript;
import org.exoplatform.web.application.javascript.JavascriptConfigDeployer;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

public class JavascriptConfigService
extends AbstractResourceService
implements Startable {
    private final Logger log = LoggerFactory.getLogger(JavascriptConfigService.class);
    private List<Javascript> commonJScripts;
    private HashMap<String, List<Javascript.PortalJScript>> portalJScripts;
    private long lastModified = Long.MAX_VALUE;
    private WebAppListener deployer;
    private CachedJavascript mergedCommonJScripts;
    private final FutureMap<String, CachedJavascript, ResourceResolver> cache;

    public JavascriptConfigService(ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        Loader<String, CachedJavascript, ResourceResolver> loader = new Loader<String, CachedJavascript, ResourceResolver>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CachedJavascript retrieve(ResourceResolver context, String key) throws Exception {
                Resource resource = context.resolve(key);
                if (resource == null) {
                    return null;
                }
                StringBuilder sB = new StringBuilder();
                try {
                    BufferedReader reader = new BufferedReader(resource.read());
                    String line = reader.readLine();
                    try {
                        while (line != null) {
                            sB.append(line);
                            line = reader.readLine();
                            if (line == null) continue;
                            sB.append("\n");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        Safe.close((Closeable)reader);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return new CachedJavascript(sB.toString());
            }
        };
        this.cache = new FutureMap((Loader)loader);
        this.commonJScripts = new ArrayList<Javascript>();
        this.deployer = new JavascriptConfigDeployer(context.getPortalContainerName(), this);
        this.portalJScripts = new HashMap();
        this.addResourceResolver(new ExtendedJScriptResourceResolver());
    }

    @Deprecated
    public Collection<String> getAvailableScripts() {
        ArrayList<String> list = new ArrayList<String>();
        for (Javascript js : this.commonJScripts) {
            list.add(js.getModule());
        }
        return list;
    }

    public Collection<Javascript> getCommonJScripts() {
        return this.commonJScripts;
    }

    @Deprecated
    public Collection<String> getAvailableScriptsPaths() {
        ArrayList<String> list = new ArrayList<String>();
        for (Javascript js : this.commonJScripts) {
            list.add(js.getPath());
        }
        return list;
    }

    public void addCommonJScript(Javascript js) {
        this.commonJScripts.add(js);
        Collections.sort(this.commonJScripts, new Comparator<Javascript>(){

            @Override
            public int compare(Javascript o1, Javascript o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        this.invalidateMergedCommonJScripts();
    }

    public void removeCommonJScript(String module) {
        Iterator<Javascript> iterator = this.commonJScripts.iterator();
        while (iterator.hasNext()) {
            Javascript js = iterator.next();
            if (!js.getModule().equals(module)) continue;
            iterator.remove();
            this.invalidateCachedJScript(js.getPath());
            this.invalidateMergedCommonJScripts();
        }
    }

    public Collection<Javascript.PortalJScript> getPortalJScripts(String portalName) {
        return this.portalJScripts.get(portalName);
    }

    public void addPortalJScript(Javascript.PortalJScript js) {
        List<Javascript.PortalJScript> list = this.portalJScripts.get(js.getPortalName());
        if (list == null) {
            list = new ArrayList<Javascript.PortalJScript>();
        }
        list.add(js);
        Collections.sort(list, new Comparator<Javascript>(){

            @Override
            public int compare(Javascript o1, Javascript o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        this.portalJScripts.put(js.getPortalName(), list);
    }

    public void removePortalJScripts(String portalName) {
        List<Javascript.PortalJScript> list = this.portalJScripts.remove(portalName);
        for (Javascript.PortalJScript js : list) {
            this.invalidateCachedJScript(js.getPath());
        }
    }

    @Override
    public void unregisterServletContext(ServletContext servletContext) {
        super.unregisterServletContext(servletContext);
        this.remove(servletContext);
    }

    public synchronized void remove(ServletContext context) {
        Iterator<Javascript> iterator = this.commonJScripts.iterator();
        while (iterator.hasNext()) {
            Javascript js = iterator.next();
            if (!js.getContextPath().equals(context.getContextPath())) continue;
            iterator.remove();
            this.invalidateCachedJScript(js.getPath());
            this.invalidateMergedCommonJScripts();
        }
    }

    @Deprecated
    public void refreshMergedJavascript() {
        this.invalidateMergedCommonJScripts();
    }

    @Deprecated
    public void writeMergedJavascript(OutputStream out) throws IOException {
        byte[] jsBytes = this.getMergedJavascript();
        out.write(jsBytes);
    }

    public String getJScript(String path) {
        CachedJavascript cachedJScript = this.getCachedJScript(path);
        if (cachedJScript != null) {
            return cachedJScript.getText();
        }
        return null;
    }

    public CachedJavascript getCachedJScript(String path) {
        return (CachedJavascript)this.cache.get((Object)this.mainResolver, (Object)path);
    }

    public CachedJavascript getMergedCommonJScripts() {
        if (this.mergedCommonJScripts == null) {
            StringBuilder sB = new StringBuilder();
            for (Javascript js : this.commonJScripts) {
                String jScript;
                if (js.isExternalScript() || (jScript = this.getJScript(js.getPath())) == null) continue;
                sB.append(jScript).append("\n");
            }
            String jScript = sB.toString();
            try {
                jScript = this.compressor.compress(jScript, ResourceType.JAVASCRIPT);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mergedCommonJScripts = new CachedJavascript(jScript);
            this.lastModified = this.mergedCommonJScripts.getLastModified();
        }
        return this.mergedCommonJScripts;
    }

    @Deprecated
    public byte[] getMergedJavascript() {
        String mergedCommonJS = this.getMergedCommonJScripts().getText();
        return mergedCommonJS.getBytes();
    }

    @Deprecated
    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModuleLoaded(CharSequence module) {
        for (Javascript js : this.commonJScripts) {
            if (!js.getModule().equals(module)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public synchronized void addExtendedJavascript(String module, String scriptPath, ServletContext scontext, String scriptData) {
        Javascript.ExtendedJScript js = new Javascript.ExtendedJScript(module, scriptPath, scontext.getContextPath(), scriptData);
        this.commonJScripts.add(js);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added an extended javascript " + js));
        }
    }

    @Deprecated
    public void removeExtendedJavascript(String module, String scriptPath, ServletContext scontext) {
        this.removeCommonJScript(module);
    }

    public void invalidateMergedCommonJScripts() {
        this.mergedCommonJScripts = null;
    }

    public void invalidateCachedJScript(String path) {
        this.cache.remove((Serializable)((Object)path));
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener(this.deployer);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener(this.deployer);
    }

    private class ExtendedJScriptResourceResolver
    implements ResourceResolver {
        private ExtendedJScriptResourceResolver() {
        }

        @Override
        public Resource resolve(String path) throws NullPointerException {
            for (Javascript js : JavascriptConfigService.this.commonJScripts) {
                if (!(js instanceof Javascript.ExtendedJScript) || !js.getPath().equals(path)) continue;
                final String jScript = ((Javascript.ExtendedJScript)js).getScript();
                return new Resource(path){

                    @Override
                    public Reader read() throws IOException {
                        return new StringReader(jScript);
                    }
                };
            }
            return null;
        }
    }
}

