/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletContext;
import org.exoplatform.portal.resource.Resource;

class SimpleResourceContext {
    private final String contextPath;
    private final ServletContext context;

    public SimpleResourceContext(String contextPath, ServletContext context) {
        this.contextPath = contextPath;
        this.context = context;
    }

    public Resource getResource(String path) {
        int i2 = path.lastIndexOf("/") + 1;
        String targetedParentPath = path.substring(0, i2);
        String targetedFileName = path.substring(i2);
        final InputStream inputStream = this.context.getResourceAsStream(path);
        if (inputStream != null) {
            return new Resource(this.contextPath, targetedParentPath, targetedFileName){

                @Override
                public Reader read() throws IOException {
                    return new InputStreamReader(inputStream);
                }
            };
        }
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

