/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.ByteArrayOutput;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.CachedStylesheet;
import org.exoplatform.portal.resource.CommentBlockHandler;
import org.exoplatform.portal.resource.CompositeResourceResolver;
import org.exoplatform.portal.resource.CompositeSkin;
import org.exoplatform.portal.resource.GateInSkinConfigDeployer;
import org.exoplatform.portal.resource.GateInSkinConfigRemoval;
import org.exoplatform.portal.resource.RenderingException;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkipCommentReader;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="skin")})
@ManagedDescription(value="Skin service")
@RESTEndpoint(path="skinservice")
public class SkinService
extends AbstractResourceService
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"portal.SkinService");
    private static final Map<Orientation, String> suffixMap = new EnumMap<Orientation, String>(Orientation.class);
    private static final String LEFT_P = "\\(";
    private static final String RIGHT_P = "\\)";
    private static final Pattern IMPORT_PATTERN;
    private static final Pattern BACKGROUND_PATTERN;
    private static final Pattern LT;
    private static final Pattern RT;
    public static final String DEFAULT_SKIN = "Default";
    private final WebAppListener deployer;
    private final WebAppListener removal;
    private final Map<SkinKey, SkinConfig> portalSkins_;
    private final Map<SkinKey, SkinConfig> skinConfigs_;
    private final HashSet<String> availableSkins_;
    private final FutureMap<String, CachedStylesheet, Orientation> ltCache;
    private final FutureMap<String, CachedStylesheet, Orientation> rtCache;
    private final Map<String, Set<String>> portletThemes_;
    final String portalContainerName;
    final String id = Long.toString(System.currentTimeMillis());
    private static final long MAX_AGE;

    public SkinService(ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        Loader<String, CachedStylesheet, Orientation> loader = new Loader<String, CachedStylesheet, Orientation>(){

            public CachedStylesheet retrieve(Orientation context, String key) throws Exception {
                Resource skin = SkinService.this.getCSSResource(key, key);
                if (skin == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                SkinService.this.processCSSRecursively(sb, true, skin, context);
                String css = sb.toString();
                try {
                    if (SkinService.this.compressor.isSupported(ResourceType.STYLESHEET)) {
                        css = SkinService.this.compressor.compress(css, ResourceType.STYLESHEET);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Error when compressing CSS " + key + " for orientation " + context + " will use normal CSS instead"), (Throwable)e);
                }
                return new CachedStylesheet(css);
            }
        };
        this.portalSkins_ = new LinkedHashMap<SkinKey, SkinConfig>();
        this.skinConfigs_ = new LinkedHashMap<SkinKey, SkinConfig>(20);
        this.availableSkins_ = new HashSet(5);
        this.ltCache = new FutureMap((Loader)loader);
        this.rtCache = new FutureMap((Loader)loader);
        this.portletThemes_ = new HashMap<String, Set<String>>();
        this.portalContainerName = context.getPortalContainerName();
        this.deployer = new GateInSkinConfigDeployer(this.portalContainerName, this);
        this.removal = new GateInSkinConfigRemoval(this);
        this.addResourceResolver(new CompositeResourceResolver(this.portalContainerName, this.skinConfigs_));
    }

    public void addCategoryTheme(String categoryName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addPortalSkin(module, skinName, cssPath);
    }

    public void addPortalSkin(String module, String skinName, String cssPath) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.addPortalSkin(module, skinName, cssPath, overwrite);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addPortalSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addPortalSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.portalSkins_.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(this, module, skinName, cssPath, priority);
            this.portalSkins_.put(key, skinConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding Portal skin : Bind " + key + " to " + skinConfig));
            }
        }
    }

    @Deprecated
    public void addPortalSkin(String module, String skinName, String cssPath, String cssData) {
        throw new UnsupportedOperationException("This method is not supported anymore.");
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext) {
        this.addSkin(module, skinName, cssPath);
    }

    public void addSkin(String module, String skinName, String cssPath) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, false);
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, ServletContext scontext, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, overwrite);
    }

    public void addSkin(String module, String skinName, String cssPath, boolean overwrite) {
        this.addSkin(module, skinName, cssPath, Integer.MAX_VALUE, overwrite);
    }

    public void addSkin(String module, String skinName, String cssPath, int priority, boolean overwrite) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null || overwrite) {
            if (priority < 0) {
                priority = Integer.MAX_VALUE;
            }
            skinConfig = new SimpleSkin(this, module, skinName, cssPath, priority);
            this.skinConfigs_.put(key, skinConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding skin : Bind " + key + " to " + skinConfig));
            }
        }
    }

    @Deprecated
    public void addSkin(String module, String skinName, String cssPath, String cssData) {
        this.availableSkins_.add(skinName);
        SkinKey key = new SkinKey(module, skinName);
        SkinConfig skinConfig = this.skinConfigs_.get(key);
        if (skinConfig == null) {
            this.skinConfigs_.put(key, new SimpleSkin(this, module, skinName, cssPath));
        }
        this.ltCache.remove((Serializable)((Object)cssPath));
        this.rtCache.remove((Serializable)((Object)cssPath));
    }

    public Skin merge(Collection<SkinConfig> skins) {
        return new CompositeSkin(this, skins);
    }

    public void addTheme(String categoryName, List<String> themesName) {
        if (!this.portletThemes_.containsKey(categoryName)) {
            this.portletThemes_.put(categoryName, new HashSet());
        }
        Set<String> catThemes = this.portletThemes_.get(categoryName);
        for (String theme : themesName) {
            catThemes.add(theme);
        }
    }

    public Set<String> getAvailableSkinNames() {
        return this.availableSkins_;
    }

    public String getCSS(String path) {
        try {
            final ByteArrayOutput output = new ByteArrayOutput();
            boolean success = this.renderCSS(new ResourceRenderer(){

                @Override
                public BinaryOutput getOutput() throws IOException {
                    return output;
                }

                @Override
                public void setExpiration(long seconds) {
                }
            }, path);
            if (success) {
                return output.getString();
            }
            return null;
        }
        catch (IOException e) {
            log.error((Object)("Error while rendering css " + path), (Throwable)e);
            return null;
        }
        catch (RenderingException e) {
            log.error((Object)("Error while rendering css " + path), (Throwable)e);
            return null;
        }
    }

    public boolean renderCSS(ResourceRenderer renderer, String path) throws RenderingException, IOException {
        Orientation orientation = Orientation.LT;
        if (path.endsWith("-lt.css")) {
            path = path.substring(0, path.length() - "-lt.css".length()) + ".css";
        } else if (path.endsWith("-rt.css")) {
            path = path.substring(0, path.length() - "-rt.css".length()) + ".css";
            orientation = Orientation.RT;
        }
        if (PropertyManager.isDevelopping()) {
            StringBuffer sb = new StringBuffer();
            Resource skin = this.getCSSResource(path, path);
            if (skin == null) {
                return false;
            }
            this.processCSSRecursively(sb, false, skin, orientation);
            byte[] bytes = sb.toString().getBytes("UTF-8");
            renderer.getOutput().write(bytes);
        } else {
            FutureMap<String, CachedStylesheet, Orientation> cache = orientation == Orientation.LT ? this.ltCache : this.rtCache;
            CachedStylesheet cachedCss = (CachedStylesheet)cache.get((Object)orientation, (Object)path);
            if (cachedCss == null) {
                return false;
            }
            renderer.setExpiration(MAX_AGE);
            cachedCss.writeTo(renderer.getOutput());
        }
        return true;
    }

    @Deprecated
    public String getMergedCSS(String path) {
        return this.getCSS(path);
    }

    public Collection<SkinConfig> getPortalSkins(String skinName) {
        Set<SkinKey> keys = this.portalSkins_.keySet();
        ArrayList<SkinConfig> portalSkins = new ArrayList<SkinConfig>();
        for (SkinKey key : keys) {
            if (!key.getName().equals(skinName)) continue;
            portalSkins.add(this.portalSkins_.get(key));
        }
        Collections.sort(portalSkins, new Comparator<SkinConfig>(){

            @Override
            public int compare(SkinConfig o1, SkinConfig o2) {
                return o1.getCSSPriority() - o2.getCSSPriority();
            }
        });
        return portalSkins;
    }

    public Map<String, Set<String>> getPortletThemes() {
        return this.portletThemes_;
    }

    public SkinConfig getSkin(String module, String skinName) {
        SkinConfig config = this.skinConfigs_.get(new SkinKey(module, skinName));
        if (config == null) {
            this.skinConfigs_.get(new SkinKey(module, DEFAULT_SKIN));
        }
        return config;
    }

    @Deprecated
    public void invalidatePortalSkinCache(String portalName, String skinName) {
        SkinKey key = new SkinKey(portalName, skinName);
        this.skinConfigs_.remove(key);
    }

    public void invalidateCachedSkin(String path) {
        this.ltCache.remove((Serializable)((Object)path));
        this.rtCache.remove((Serializable)((Object)path));
    }

    public long getLastModified(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (PropertyManager.isDevelopping()) {
            return Long.MAX_VALUE;
        }
        FutureMap<String, CachedStylesheet, Orientation> cache = this.ltCache;
        Orientation orientation = Orientation.LT;
        if (path.endsWith("-lt.css")) {
            path = path.substring(0, path.length() - "-lt.css".length()) + ".css";
        } else if (path.endsWith("-rt.css")) {
            path = path.substring(0, path.length() - "-rt.css".length()) + ".css";
            orientation = Orientation.RT;
        }
        CachedStylesheet cachedCSS = (CachedStylesheet)cache.get((Object)orientation, (Object)path);
        if (cachedCSS == null) {
            return Long.MAX_VALUE;
        }
        return cachedCSS.getLastModified();
    }

    @Deprecated
    public void remove(String module, String skinName) {
        this.removeSkin(module, skinName);
    }

    public void removeSkin(String module, String skinName) {
        SkinKey key = skinName.length() == 0 ? new SkinKey(module, DEFAULT_SKIN) : new SkinKey(module, skinName);
        this.removeSkin(key);
    }

    public void removeSkin(SkinKey key) {
        if (key == null) {
            return;
        }
        SkinConfig remove = this.skinConfigs_.remove(key);
        if (remove != null) {
            this.invalidateCachedSkin(remove.getCSSPath());
        }
    }

    @Deprecated
    public void remove(List<SkinKey> keys) throws Exception {
        this.removeSkins(keys);
    }

    public void removeSkins(List<SkinKey> keys) throws Exception {
        if (keys == null) {
            return;
        }
        for (SkinKey key : keys) {
            this.removeSkin(key);
        }
    }

    public void removeSupportedSkin(String skinName) throws Exception {
        this.availableSkins_.remove(skinName);
    }

    public int size() {
        return this.skinConfigs_.size();
    }

    private Resource getCSSResource(String cssPath, String outerCssFile) {
        Resource resource = this.mainResolver.resolve(cssPath);
        if (resource == null && log.isErrorEnabled()) {
            String logMessage;
            if (!cssPath.equals(outerCssFile)) {
                int lastIndexOfSlash = cssPath.lastIndexOf(47);
                String loadedCssFile = lastIndexOfSlash >= 0 ? cssPath.substring(lastIndexOfSlash + 1) : cssPath;
                logMessage = "Invalid <CSS FILE> configuration, please check the @import url(" + loadedCssFile + ") in " + outerCssFile + " , SkinService could not load the skin " + cssPath;
            } else {
                logMessage = "Not found <CSS FILE>, the path " + cssPath + " is invalid, SkinService could not load the skin " + cssPath;
            }
            log.error((Object)logMessage);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCSSRecursively(Appendable appendable, boolean merge, Resource skin, Orientation orientation) throws RenderingException, IOException {
        if (skin == null) {
            return;
        }
        String basePath = skin.getContextPath() + skin.getParentPath();
        Reader tmp = skin.read();
        if (tmp == null) {
            throw new RenderingException("No skin resolved for path " + skin.getResourcePath());
        }
        SkipCommentReader reader = new SkipCommentReader(tmp, new CommentBlockHandler.OrientationCommentBlockHandler());
        try {
            String line = ((BufferedReader)reader).readLine();
            while (line != null) {
                line = this.proccessOrientation(line, orientation);
                line = this.proccessBackgroundUrl(line, basePath);
                Matcher matcher = IMPORT_PATTERN.matcher(line);
                while (matcher.find()) {
                    String includedPath = matcher.group(2);
                    if (!includedPath.startsWith("/")) {
                        includedPath = basePath + includedPath;
                    }
                    String embeddedPath = includedPath.substring(0, includedPath.length() - ".css".length());
                    StringBuffer strReplace = new StringBuffer();
                    if (merge) {
                        Resource ssskin = this.getCSSResource(includedPath, basePath + skin.getFileName());
                        this.processCSSRecursively(strReplace, merge, ssskin, orientation);
                    } else {
                        strReplace.append(matcher.group(1));
                        strReplace.append(embeddedPath);
                        strReplace.append(this.getSuffix(orientation));
                        strReplace.append(matcher.group(3));
                    }
                    String str = strReplace.toString().replaceAll("\\$", "\\\\\\$");
                    matcher.appendReplacement((StringBuffer)appendable, str);
                }
                matcher.appendTail((StringBuffer)appendable);
                line = ((BufferedReader)reader).readLine();
                if (line == null) continue;
                appendable.append("\n");
            }
        }
        finally {
            Safe.close((Closeable)reader);
        }
    }

    private String proccessBackgroundUrl(String line, String basePath) {
        Matcher matcher = BACKGROUND_PATTERN.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).startsWith("\"/") || matcher.group(2).startsWith("'/") || matcher.group(2).startsWith("/")) continue;
            StringBuilder strReplace = new StringBuilder();
            strReplace.append(matcher.group(1));
            strReplace.append(basePath);
            strReplace.append(matcher.group(2));
            strReplace.append(matcher.group(3));
            matcher.appendReplacement(tmpBuilder, strReplace.toString());
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    private String proccessOrientation(String line, Orientation orientation) {
        Pattern orientationPattern = orientation == Orientation.LT ? RT : LT;
        Matcher matcher = orientationPattern.matcher(line);
        StringBuffer tmpBuilder = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(tmpBuilder, "");
        }
        matcher.appendTail(tmpBuilder);
        return tmpBuilder.toString();
    }

    String getSuffix(Orientation orientation) {
        if (orientation == null) {
            orientation = Orientation.LT;
        }
        return suffixMap.get(orientation);
    }

    @Managed
    @ManagedDescription(value="The list of registered skins identifiers")
    public String[] getSkinList() {
        ArrayList<String> availableSkin = new ArrayList<String>();
        for (String skin : this.availableSkins_) {
            availableSkin.add(skin);
        }
        Collections.sort(availableSkin);
        return availableSkin.toArray(new String[availableSkin.size()]);
    }

    @Managed
    @ManagedDescription(value="Reload all skins")
    @Impact(value=ImpactType.WRITE)
    public void reloadSkins() {
        this.ltCache.clear();
        this.rtCache.clear();
    }

    @Managed
    @ManagedDescription(value="Reload a specified skin")
    public void reloadSkin(@ManagedDescription(value="The skin id") @ManagedName(value="skinId") String skinId) {
        this.ltCache.remove((Serializable)((Object)skinId));
        this.rtCache.remove((Serializable)((Object)skinId));
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener(this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener(this.removal);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener(this.deployer);
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener(this.removal);
    }

    static {
        suffixMap.put(Orientation.LT, "-lt.css");
        suffixMap.put(Orientation.RT, "-rt.css");
        suffixMap.put(Orientation.TL, "-lt.css");
        suffixMap.put(Orientation.TR, "-lt.css");
        IMPORT_PATTERN = Pattern.compile("(@import\\s+url\\(['\"]?)([^'\";]+.css)(['\"]?\\)\\s*;)");
        BACKGROUND_PATTERN = Pattern.compile("(background[^;]+url\\(['\"]?)([^'\";]+)(['\"]?\\)[^;]*;)");
        LT = Pattern.compile("[^{;]*;\\s*/\\*\\s*orientation=lt\\s*\\*/");
        RT = Pattern.compile("[^{;]*;\\s*/\\*\\s*orientation=rt\\s*\\*/");
        long seconds = 86400L;
        String propValue = PropertyManager.getProperty((String)"gatein.assets.css.max-age");
        if (propValue != null) {
            try {
                seconds = Long.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"The gatein.assets.css.max-age property is not set properly.");
            }
        }
        MAX_AGE = seconds;
    }
}

