/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.compressor.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.portal.resource.compressor.ResourceCompressorException;
import org.exoplatform.portal.resource.compressor.ResourceCompressorPlugin;
import org.exoplatform.portal.resource.compressor.ResourceType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@ManagedDescription(value="The resource compressor service")
@NameTemplate(value={@Property(key="service", value="resource")})
public class ResourceCompressorService
implements ResourceCompressor,
ManagementAware {
    private Log log = ExoLogger.getLogger(ResourceCompressorService.class);
    private Map<ResourceType, List<ResourceCompressorPlugin>> plugins = new HashMap<ResourceType, List<ResourceCompressorPlugin>>();

    public ResourceCompressorService(InitParams params) throws Exception {
    }

    public void registerCompressorPlugin(ComponentPlugin plugin) {
        if (plugin instanceof ResourceCompressorPlugin) {
            ResourceCompressorPlugin compressorPlugin = (ResourceCompressorPlugin)plugin;
            ResourceType type = compressorPlugin.getResourceType();
            List<ResourceCompressorPlugin> sameResourceTypePlugins = this.plugins.get((Object)type);
            if (sameResourceTypePlugins != null) {
                sameResourceTypePlugins.add(compressorPlugin);
                this.log.debug((Object)("Loaded compressor plugin: " + compressorPlugin.getName() + " for resource type " + type.toString()));
            } else {
                ArrayList<ResourceCompressorPlugin> newListOfPlugins = new ArrayList<ResourceCompressorPlugin>();
                newListOfPlugins.add(compressorPlugin);
                this.log.debug((Object)("Loaded compressor plugin: " + compressorPlugin.getName() + " for new resource type " + type.toString()));
                this.plugins.put(type, newListOfPlugins);
            }
        }
    }

    public ResourceCompressorPlugin getCompressorPlugin(ResourceType type, String name) {
        List<ResourceCompressorPlugin> sameResourceTypePlugins = this.plugins.get((Object)type);
        if (sameResourceTypePlugins != null) {
            for (ResourceCompressorPlugin plugin : sameResourceTypePlugins) {
                if (!plugin.getName().equals(name)) continue;
                return plugin;
            }
        }
        return null;
    }

    @Override
    public final boolean isSupported(ResourceType resourceType) {
        return this.getHighestPriorityCompressorPlugin(resourceType) != null;
    }

    @Override
    public final void compress(Reader input, Writer output, ResourceType resourceType) throws ResourceCompressorException, IOException {
        ResourceCompressorPlugin plugin = this.getHighestPriorityCompressorPlugin(resourceType);
        if (plugin == null) {
            throw new ResourceCompressorException("There is no compressor for " + (Object)((Object)resourceType) + " type");
        }
        plugin.compress(input, output);
    }

    @Override
    public String compress(String input, ResourceType resourceType) throws ResourceCompressorException, IOException {
        StringReader reader = new StringReader(input);
        StringWriter writer = new StringWriter();
        this.compress(reader, writer, resourceType);
        return writer.toString();
    }

    public ResourceCompressorPlugin getHighestPriorityCompressorPlugin(ResourceType resourceType) {
        List<ResourceCompressorPlugin> candidates = this.plugins.get((Object)resourceType);
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        int highestPriorityIndex = 0;
        int maxPriority = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            int currentPriority = candidates.get(i).getPriority();
            if (currentPriority <= maxPriority) continue;
            highestPriorityIndex = i;
            maxPriority = currentPriority;
        }
        return candidates.get(highestPriorityIndex);
    }

    public void setContext(ManagementContext context) {
        if (context == null) {
            return;
        }
        for (Map.Entry<ResourceType, List<ResourceCompressorPlugin>> entry : this.plugins.entrySet()) {
            for (ResourceCompressorPlugin plugin : entry.getValue()) {
                context.register((Object)plugin);
            }
        }
    }
}

